/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.method.CharacterUnpackingInputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.search.IntRange;
import me.shedaniel.rei.impl.client.search.argument.AlternativeArgument;
import me.shedaniel.rei.impl.client.search.argument.ArgumentCache;
import me.shedaniel.rei.impl.client.search.argument.CompoundArgument;
import me.shedaniel.rei.impl.client.search.argument.InputMethodMatcher;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentTypesRegistry;
import me.shedaniel.rei.impl.client.search.collapsed.CollapsedEntriesCache;
import me.shedaniel.rei.impl.client.search.result.ArgumentApplicableResult;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HNEntryStackWrapper;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class Argument<T, R> {
    public static final Object NO_CACHE = new Object();
    private static final AtomicReference<String> LAST_LANGUAGE = new AtomicReference();
    public static ArgumentCache cache = new ArgumentCache();
    private final ArgumentType<T, R> argumentType;
    private final String text;
    private final T filterData;
    private final boolean regular;
    private final int start;
    private final int end;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?:\"([^\"]*)\")|([^\\s]+)");

    public Argument(ArgumentType<T, R> argumentType, String text, boolean regular, T filterData, int start, int end, boolean lowercase) {
        this.argumentType = argumentType;
        this.text = lowercase ? text.toLowerCase(Locale.ROOT) : text;
        this.regular = regular;
        this.filterData = filterData;
        this.start = start;
        this.end = end;
    }

    public static void resetCache(boolean cache) {
        Argument.cache = new ArgumentCache();
        CollapsedEntriesCache.reset();
        List<HashedEntryStackWrapper> stacks = CollectionUtils.map(((EntryRegistryImpl)EntryRegistry.getInstance()).getComplexList(), HNEntryStackWrapper::normalize);
        if (cache) {
            Argument.cache.prepareFilter(stacks, ArgumentTypesRegistry.ARGUMENT_TYPE_LIST, ArgumentCache.EXECUTOR_SERVICE);
        }
        CollapsedEntriesCache.getInstance().prepare(stacks);
    }

    public static boolean hasCache() {
        return !cache.isEmpty();
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public static List<CompoundArgument> bakeArguments(String filter) {
        return Argument.bakeArguments(filter, null);
    }

    public static List<CompoundArgument> bakeArguments(String filter, @Nullable ProcessedSink sink) {
        ArrayList compoundArguments = Lists.newArrayList();
        int tokenStartIndex = 0;
        for (String token : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)filter, (String)"|")) {
            Matcher terms = SPLIT_PATTERN.matcher(token);
            CompoundArgument.Builder builder = CompoundArgument.builder();
            while (terms.find()) {
                AlternativeArgument.Builder alternativeBuilder = AlternativeArgument.builder();
                for (ArgumentType<?, ?> type : ArgumentTypesRegistry.ARGUMENT_TYPE_LIST) {
                    Argument.applyArgument(type, filter, terms, tokenStartIndex, alternativeBuilder, true, sink);
                    if (alternativeBuilder.isEmpty()) continue;
                    break;
                }
                if (alternativeBuilder.isEmpty()) {
                    for (ArgumentType<?, ?> type : ArgumentTypesRegistry.ARGUMENT_TYPE_LIST) {
                        Argument.applyArgument(type, filter, terms, tokenStartIndex, alternativeBuilder, false, sink);
                    }
                }
                builder.add(alternativeBuilder);
            }
            compoundArguments.add(builder.build());
            if (sink == null || (tokenStartIndex += 1 + token.length()) - 1 >= filter.length()) continue;
            sink.addSplitter(tokenStartIndex - 1);
        }
        return compoundArguments;
    }

    private static void applyArgument(ArgumentType<?, ?> type, String filter, Matcher terms, int tokenStartIndex, AlternativeArgument.Builder alternativeBuilder, boolean forceGrammar, @Nullable ProcessedSink sink) {
        String term = (String)MoreObjects.firstNonNull((Object)terms.group(1), (Object)terms.group(2));
        if (type.getSearchMode() == SearchMode.NEVER) {
            return;
        }
        ArgumentApplicableResult result = type.checkApplicable(term, forceGrammar);
        if (result.isApplicable()) {
            int group = terms.group(1) != null ? 1 : 2;
            Builder argument = new Builder(type, result.getText(), !result.isInverted(), terms.start(group) + tokenStartIndex, terms.end(group) + tokenStartIndex, !result.shouldPreserveCasing());
            alternativeBuilder.add(argument);
            if (sink != null) {
                if (group == 1) {
                    sink.addQuote(terms.start() + tokenStartIndex);
                    if (terms.end() - 1 + tokenStartIndex < filter.length()) {
                        sink.addQuote(terms.end() - 1 + tokenStartIndex);
                    }
                }
                sink.addPart(argument, result.isUsingGrammar(), result.grammarRanges(), terms.start() + tokenStartIndex);
            }
        }
    }

    public static boolean matches(EntryStack<?> stack, long hashExact, List<CompoundArgument> compoundArguments, InputMethod<?> inputMethod) {
        if (compoundArguments.isEmpty()) {
            return true;
        }
        String newLanguage = Minecraft.getInstance().options.languageCode;
        if (!Objects.equals(LAST_LANGUAGE.getAndSet(newLanguage), newLanguage)) {
            Argument.resetCache(false);
        }
        block0: for (CompoundArgument arguments : compoundArguments) {
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                AlternativeArgument argument = (AlternativeArgument)((Object)iterator.next());
                if (Argument.matches(stack, hashExact, argument, inputMethod)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static <T> boolean matches(EntryStack<?> stack, long hashExact, AlternativeArgument alternativeArgument, InputMethod<T> inputMethod) {
        if (alternativeArgument.isEmpty()) {
            return true;
        }
        ResultSinkImpl<T> sink = new ResultSinkImpl<T>(inputMethod);
        Iterator iterator = alternativeArgument.iterator();
        while (iterator.hasNext()) {
            Argument argument = (Argument)iterator.next();
            sink.filters = inputMethod.expendFilter(argument.getText());
            if (Argument.matches(argument.getArgument(), stack, hashExact, argument.filterData, sink) != argument.isRegular()) continue;
            return true;
        }
        return false;
    }

    private static <T, R, B> boolean matches(ArgumentType<T, B> argumentType, EntryStack<?> stack, long hashExact, R filterData, ResultSinkImpl<?> sink) {
        Long2ObjectMap<Object> map = cache.getSearchCache(argumentType);
        Object value = map.get(hashExact);
        if (value == null) {
            value = argumentType.cacheData(stack);
            map.put(hashExact, value == null ? NO_CACHE : value);
        }
        sink.matches = false;
        argumentType.matches(value == NO_CACHE ? null : value, stack, filterData, sink);
        return sink.matches;
    }

    public ArgumentType<?, ?> getArgument() {
        return this.argumentType;
    }

    public String getText() {
        return this.text;
    }

    public boolean isRegular() {
        return this.regular;
    }

    public String toString() {
        return String.format("Argument[%s]: name = %s, regular = %b", this.argumentType.getName(), this.text, this.regular);
    }

    public static interface ProcessedSink {
        public void addQuote(int var1);

        public void addSplitter(int var1);

        public void addPart(Builder<?, ?> var1, boolean var2, Collection<IntRange> var3, int var4);
    }

    public static class Builder<T, R> {
        private final ArgumentType<T, R> argumentType;
        private final String text;
        private final boolean regular;
        private final int start;
        private final int end;
        private final boolean lowercase;

        public Builder(ArgumentType<T, R> argumentType, String text, boolean regular, int start, int end, boolean lowercase) {
            this.argumentType = argumentType;
            this.text = text;
            this.regular = regular;
            this.start = start;
            this.end = end;
            this.lowercase = lowercase;
        }

        public Argument<T, R> build() {
            return new Argument<T, R>(this.argumentType, this.text, this.regular, this.argumentType.prepareSearchFilter(this.text), this.start, this.end, this.lowercase);
        }

        public ArgumentType<T, R> getType() {
            return this.argumentType;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public String getText() {
            return this.text;
        }

        public boolean isRegular() {
            return this.regular;
        }

        public boolean isLowercase() {
            return this.lowercase;
        }
    }

    private static class ResultSinkImpl<T>
    implements ArgumentType.ResultSink {
        private final InputMethod<T> inputMethod;
        private boolean matches;
        private Iterable<T> filters;

        public ResultSinkImpl(InputMethod<T> inputMethod) {
            this.inputMethod = inputMethod;
        }

        @Override
        public boolean testTrue() {
            this.matches = true;
            return true;
        }

        @Override
        public boolean testString(String text) {
            if (this.matches) {
                return true;
            }
            InputMethod<T> inputMethod = this.inputMethod;
            if (inputMethod instanceof CharacterUnpackingInputMethod) {
                CharacterUnpackingInputMethod im = (CharacterUnpackingInputMethod)inputMethod;
                for (T filter : this.filters) {
                    if (!InputMethodMatcher.contains(im, IntList.of((int[])text.codePoints().toArray()), (IntList)filter)) continue;
                    this.matches = true;
                    return true;
                }
            } else {
                for (T filter : this.filters) {
                    if (!this.inputMethod.contains(text, filter)) continue;
                    this.matches = true;
                    return true;
                }
            }
            return false;
        }
    }
}

