/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.gui.widget.DisplayCompositeWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayEntry;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class DisplayHistoryWidget
extends WidgetWithBounds
implements DraggableComponentVisitorWidget,
DraggableComponentProviderWidget<Object> {
    private final FavoritesListWidget parent;
    private final Rectangle bounds = new Rectangle();
    private final NumberAnimator<Double> height;
    private boolean ignoreNextMouse;
    private final NumberAnimator<Double> scroll = ValueAnimator.ofDouble();

    public DisplayHistoryWidget(FavoritesListWidget parent) {
        this.parent = parent;
        this.height = ValueAnimator.ofDouble().withConvention(() -> {
            boolean draggingDisplay;
            boolean bl = draggingDisplay = DraggingContext.getInstance().isDraggingComponent() && DraggingContext.getInstance().getDragged().get() instanceof Display;
            if (draggingDisplay) {
                return Math.min((double)parent.excludedBounds.height, 80.0);
            }
            return 0.0;
        }, ValueAnimator.typicalTransitionTime());
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Rectangle fullBounds = this.parent.excludedBounds;
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>(DisplayHistoryManager.INSTANCE.getEntries(this));
        if (this.updateBounds(fullBounds)) {
            for (DisplayEntry entry : entries) {
                entry.markBoundsDirty();
            }
        }
        this.updatePosition(delta);
        double xOffset = -this.scroll.doubleValue() + (double)(entries.size() * this.getBounds().getWidth());
        for (int i = entries.size() - 1; i >= 0; --i) {
            DisplayEntry entry = (DisplayEntry)entries.get(i);
            entry.setScrolled(xOffset -= (double)this.getBounds().getWidth());
            boolean shouldScissor = entry.isStable();
            if (shouldScissor) {
                graphics.enableScissor(this.getBounds().x, this.getBounds().y, this.getBounds().getMaxX(), this.getBounds().getMaxY());
            }
            entry.render(graphics, mouseX, mouseY, delta);
            if (!shouldScissor) continue;
            graphics.disableScissor();
        }
        boolean draggingDisplay = DraggingContext.getInstance().isDraggingComponent() && DraggingContext.getInstance().getDragged().get() instanceof Display;
        double onBoardingHeight = (Double)this.height.value();
        if (entries.isEmpty() && draggingDisplay && Math.round(onBoardingHeight) > 0L) {
            double lastProgress = Math.pow(Mth.clamp((double)(onBoardingHeight / Math.min((double)this.parent.excludedBounds.height, 80.0)), (double)0.0, (double)1.0), 7.0);
            float opacity = (Mth.cos((float)((float)((double)((float)(System.currentTimeMillis() % 1000L) / 500.0f) * Math.PI))) + 1.0f) / 2.0f;
            if (ConfigObject.getInstance().isReducedMotion()) {
                opacity = 0.75f;
            }
            int alpha = (int)(80.0 * lastProgress) + (int)(66.0 * lastProgress * (double)opacity);
            int lineColor = alpha << 24 | 0xFFFFFF;
            Rectangle bounds = this.bounds.clone();
            bounds.y += 10;
            bounds.height -= 20;
            this.drawHorizontalDashedLine(graphics, bounds.x, bounds.getMaxX(), bounds.y, lineColor, false);
            this.drawHorizontalDashedLine(graphics, bounds.x, bounds.getMaxX(), bounds.getMaxY() - 1, lineColor, true);
            this.drawVerticalDashedLine(graphics, bounds.x, bounds.y, bounds.getMaxY(), lineColor, true);
            this.drawVerticalDashedLine(graphics, bounds.getMaxX() - 1, bounds.y, bounds.getMaxY(), lineColor, false);
        }
    }

    private void drawHorizontalDashedLine(GuiGraphics graphics, int x1, int x2, int y, int color, boolean reverse) {
        float[] offset = new float[]{(float)(System.currentTimeMillis() % 700L) / 100.0f};
        if (ConfigObject.getInstance().isReducedMotion()) {
            offset[0] = 0.0f;
        }
        if (!reverse) {
            offset[0] = 7.0f - offset[0];
        }
        for (float x = (float)x1 - offset[0]; x < (float)x2; x += 7.0f) {
            graphics.pose().pushMatrix();
            graphics.pose().translate(Mth.clamp((float)x, (float)x1, (float)x2), 0.0f);
            graphics.fillGradient(0, y, 4, y + 1, color, color);
            graphics.pose().popMatrix();
        }
    }

    private void drawVerticalDashedLine(GuiGraphics graphics, int x, int y1, int y2, int color, boolean reverse) {
        float[] offset = new float[]{(float)(System.currentTimeMillis() % 700L) / 100.0f};
        if (ConfigObject.getInstance().isReducedMotion()) {
            offset[0] = 0.0f;
        }
        if (!reverse) {
            offset[0] = 7.0f - offset[0];
        }
        for (float y = (float)y1 - offset[0]; y < (float)y2; y += 7.0f) {
            graphics.pose().pushMatrix();
            graphics.pose().translate(0.0f, Mth.clamp((float)y, (float)y1, (float)y2));
            graphics.fillGradient(x, 0, x + 1, 4, color, color);
            graphics.pose().popMatrix();
        }
    }

    private boolean updateBounds(Rectangle fullBounds) {
        int prevHash = this.bounds.hashCode();
        this.bounds.setBounds(this.createBounds(fullBounds));
        return prevHash != this.bounds.hashCode();
    }

    public Rectangle createBounds(Rectangle fullBounds) {
        return this.createBounds(fullBounds, (Double)this.height.value());
    }

    public Rectangle createBounds(Rectangle fullBounds, @Nullable Double height) {
        return new Rectangle(fullBounds.x + 2, fullBounds.y, fullBounds.width - 4, Math.min(fullBounds.height, 80));
    }

    public void updatePosition(float delta) {
        this.height.update((double)delta);
        this.scroll.setTarget(ScrollingContainer.handleBounceBack((double)((Double)this.scroll.target()), (double)this.getMaxScrollDist(), (float)delta, (double)0.08));
        this.scroll.update((double)delta);
        if ((Double)this.scroll.target() >= 0.0 && (Double)this.scroll.target() <= (double)this.getMaxScrollDist() && DisplayHistoryManager.INSTANCE.getEntries(this).size() > 1) {
            int before = (int)(Math.floor((Double)this.scroll.target() / (double)this.getBounds().getWidth()) * (double)this.getBounds().getWidth());
            int after = (int)(Math.ceil((Double)this.scroll.target() / (double)this.getBounds().getWidth()) * (double)this.getBounds().getWidth());
            if ((double)before <= (Double)this.scroll.target() && (double)after >= (Double)this.scroll.target()) {
                if (Math.abs((double)before - (Double)this.scroll.target()) < Math.abs((double)after - (Double)this.scroll.target())) {
                    this.scroll.setTarget((Double)this.scroll.target() - ((Double)this.scroll.target() - (double)before) * (double)delta / 2.0);
                } else {
                    this.scroll.setTarget((Double)this.scroll.target() + ((double)after - (Double)this.scroll.target()) * (double)delta / 2.0);
                }
            }
        }
    }

    public int getContentHeight() {
        Collection<DisplayEntry> entries = DisplayHistoryManager.INSTANCE.getEntries(this);
        if (entries.isEmpty()) {
            return 0;
        }
        return this.getBounds().getWidth() * entries.size();
    }

    public final int getMaxScrollDist() {
        return Math.max(0, this.getContentHeight() - this.getBounds().width);
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        Collection<DisplayEntry> entries = DisplayHistoryManager.INSTANCE.getEntries(this);
        if (this.containsMouse(mouseX, mouseY)) {
            for (DisplayEntry entry : entries) {
                if (entry.isStable()) continue;
                entry.setReachedStable(true);
            }
            this.scroll.setTo((Double)this.scroll.target() + ClothConfigInitializer.getScrollStep() * amountY * ((double)this.getBounds().getWidth() / -50.0), ClothConfigInitializer.getScrollDuration());
            return true;
        }
        for (DisplayEntry entry : entries) {
            if (!entry.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        for (DisplayEntry entry : DisplayHistoryManager.INSTANCE.getEntries(this)) {
            if (this.ignoreNextMouse || !entry.mouseClicked(event, doubleClick)) continue;
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        Point mouse;
        if (this.ignoreNextMouse) {
            this.ignoreNextMouse = false;
            return true;
        }
        Collection<DisplayEntry> entries = DisplayHistoryManager.INSTANCE.getEntries(this);
        for (DisplayEntry entry : entries) {
            if (!entry.mouseReleased(event)) continue;
            return true;
        }
        if (ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(event.button()) && this.containsMouse(mouse = PointHelper.ofMouse())) {
            double xOffset = -((Double)this.scroll.value()).doubleValue();
            for (DisplayEntry entry : entries) {
                if (!entry.isStable() || !entry.getBounds().contains((double)mouse.x + xOffset, (double)mouse.y)) continue;
                DisplayHistoryManager.INSTANCE.removeEntry(entry);
                this.scroll.setAs((Double)this.scroll.target() - (double)this.getBounds().getWidth());
                this.scroll.setTo((Double)this.scroll.target() + (double)this.getBounds().getWidth(), 800L);
                DisplayCompositeWidget.DisplayDraggableComponent component = new DisplayCompositeWidget.DisplayDraggableComponent(Widgets.concat(entry.getWidgets()), entry.getDisplay(), entry.getBounds().clone(), new Rectangle(0, 0, entry.getSize().width, entry.getSize().height));
                DraggingContext.getInstance().renderToVoid(component);
                return true;
            }
        }
        return super.mouseReleased(event);
    }

    public boolean keyPressed(KeyEvent event) {
        Point mouse;
        Collection<DisplayEntry> entries = DisplayHistoryManager.INSTANCE.getEntries(this);
        for (DisplayEntry entry : entries) {
            if (!entry.keyPressed(event)) continue;
            return true;
        }
        if (ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(event.key(), event.scancode()) && this.containsMouse(mouse = PointHelper.ofMouse())) {
            double xOffset = -((Double)this.scroll.value()).doubleValue();
            for (DisplayEntry entry : entries) {
                if (!entry.isStable() || !entry.getBounds().contains((double)mouse.x + xOffset, (double)mouse.y)) continue;
                DisplayHistoryManager.INSTANCE.removeEntry(entry);
                this.scroll.setAs((Double)this.scroll.target() - (double)this.getBounds().getWidth());
                this.scroll.setTo((Double)this.scroll.target() + (double)this.getBounds().getWidth(), 800L);
                DisplayCompositeWidget.DisplayDraggableComponent component = new DisplayCompositeWidget.DisplayDraggableComponent(Widgets.concat(entry.getWidgets()), entry.getDisplay(), entry.getBounds().clone(), new Rectangle(0, 0, entry.getSize().width, entry.getSize().height));
                DraggingContext.getInstance().renderToVoid(component);
                return true;
            }
        }
        return super.keyPressed(event);
    }

    @Override
    public DraggedAcceptorResult acceptDragged(DraggingContext<Screen> context, DraggableComponent<?> component) {
        return component.ifMatches(display -> {
            Point pos = context.getCurrentPosition();
            if (this.containsMouse(pos)) {
                this.addDisplay(context.getCurrentBounds().clone(), (Display)display);
                this.ignoreNextMouse = true;
                return true;
            }
            return false;
        }, new Display[0]) ? DraggedAcceptorResult.CONSUMED : DraggedAcceptorResult.PASS;
    }

    public void addDisplay(@Nullable Rectangle bounds, Display display) {
        DisplayHistoryManager.INSTANCE.addEntry(this, bounds, display);
        this.scroll.setAs((Double)this.scroll.target() + (double)this.getBounds().getWidth());
        this.scroll.setTo(0, ConfigObject.getInstance().isReducedMotion() ? 0L : 800L);
    }

    @Override
    @Nullable
    public DraggableComponent<Object> getHovered(DraggingContext<Screen> context, double mouseX, double mouseY) {
        if (this.containsMouse(mouseX, mouseY)) {
            double xOffset = -((Double)this.scroll.value()).doubleValue();
            Collection<DisplayEntry> entries = DisplayHistoryManager.INSTANCE.getEntries(this);
            for (final DisplayEntry entry : entries) {
                if (entry.isStable() && entry.getBounds().contains(mouseX + xOffset, mouseY)) {
                    for (DraggableComponentProviderWidget widget : Widgets.walk(entry.getWidgets(), child -> child instanceof DraggableComponentProviderWidget)) {
                        DraggableComponent<Object> hovered = widget.getHovered(context, entry.transformMouseX(mouseX), entry.transformMouseY(mouseY));
                        if (hovered == null) continue;
                        return hovered;
                    }
                    return new DisplayCompositeWidget.DisplayDraggableComponent(Widgets.concat(entry.getWidgets()), entry.getDisplay(), entry.getBounds().clone(), new Rectangle(0, 0, entry.getSize().width, entry.getSize().height)){

                        @Override
                        public void drag() {
                            DisplayHistoryManager.INSTANCE.removeEntry(entry);
                            DisplayHistoryWidget.this.scroll.setAs((Double)DisplayHistoryWidget.this.scroll.target() - (double)DisplayHistoryWidget.this.getBounds().getWidth());
                            DisplayHistoryWidget.this.scroll.setTo((Double)DisplayHistoryWidget.this.scroll.target() + (double)DisplayHistoryWidget.this.getBounds().getWidth(), ConfigObject.getInstance().isReducedMotion() ? 0L : 800L);
                        }

                        @Override
                        public void release(DraggedAcceptorResult result) {
                            if (result == DraggedAcceptorResult.PASS) {
                                DisplayHistoryWidget.this.addDisplay(DraggingContext.getInstance().getCurrentBounds().clone(), entry.getDisplay());
                            }
                        }
                    };
                }
                xOffset += (double)this.getBounds().getWidth();
            }
        }
        return null;
    }
}

