/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class MergedWidget
extends Widget {
    private final List<Widget> widgets;

    public MergedWidget(Widget widget1, Widget widget2) {
        this.widgets = Lists.newArrayList((Object[])new Widget[]{Objects.requireNonNull(widget1), Objects.requireNonNull(widget2)});
    }

    public MergedWidget(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (Widget widget : this.widgets) {
            widget.render(graphics, mouseX, mouseY, delta);
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(event)) continue;
            return true;
        }
        return false;
    }

    public boolean keyReleased(KeyEvent event) {
        for (Widget widget : this.widgets) {
            if (!widget.keyReleased(event)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(CharacterEvent event) {
        for (Widget widget : this.widgets) {
            if (!widget.charTyped(event)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double dx, double dy) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseDragged(event, dx, dy)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseReleased(event)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getZRenderingPriority() {
        return CollectionUtils.max(this.widgets, Comparator.comparingDouble(Widget::getZRenderingPriority)).map(Widget::getZRenderingPriority).orElse(0.0);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        for (Widget widget : this.widgets) {
            if (!widget.containsMouse(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.containsMouse(mouseX, mouseY)) continue;
            return Optional.of(widget);
        }
        return Optional.empty();
    }
}

