/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import net.minecraft.CrashReport;
import net.minecraft.client.gui.GuiGraphics;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;

public class EntryRendererManager<T extends EntryWidget>
implements Iterable<T> {
    private final Int2ObjectMap<List<Object>> grouping = new Int2ObjectOpenHashMap();
    private final List<T> toRender = new ArrayList<T>();

    public EntryRendererManager() {
    }

    public EntryRendererManager(Collection<? extends T> widgets) {
        this.addAll(widgets);
    }

    public void addAll(Collection<? extends T> widgets) {
        this.toRender.addAll(widgets);
    }

    public void add(T widget) {
        this.toRender.add(widget);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.render(false, null, null, graphics, mouseX, mouseY, delta);
    }

    public void render(boolean debugTime, MutableInt size, MutableLong time, GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (!this.toRender.isEmpty()) {
            EntryRendererManager.renderEntries(debugTime, size, time, graphics, mouseX, mouseY, delta, this.toRender);
        }
    }

    public static <T extends EntryWidget> void renderEntries(boolean debugTime, MutableInt size, MutableLong time, GuiGraphics graphics, int mouseX, int mouseY, float delta, Iterable<T> entries) {
        for (EntryWidget entry : entries) {
            if (entry.getCurrentEntry().isEmpty()) continue;
            try {
                if (debugTime) {
                    size.increment();
                    long l = System.nanoTime();
                    entry.render(graphics, mouseX, mouseY, delta);
                    time.add(System.nanoTime() - l);
                    continue;
                }
                entry.render(graphics, mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReportUtils.essential(throwable, "Rendering entry");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return Iterators.concat(this.toRender.iterator(), (Iterator)Iterators.concat(CollectionUtils.map(this.grouping.values(), entries -> new AbstractIterator<T>(this, (List)entries){
            public int i = 0;
            final /* synthetic */ List val$entries;
            {
                this.val$entries = list;
            }

            protected T computeNext() {
                if (this.i >= this.val$entries.size()) {
                    return (EntryWidget)this.endOfData();
                }
                EntryWidget widget = (EntryWidget)this.val$entries.get(this.i);
                this.i += 2;
                return widget;
            }
        }).iterator()));
    }
}

