/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.gui.AbstractContainerEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicErrorFreeEntryListWidget<E extends Entry<E>>
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft client;
    private final List<E> entries = new Entries();
    public int width;
    public int height;
    public int top;
    public int bottom;
    public int right;
    public int left;
    protected boolean verticallyCenter = true;
    protected int yDrag = -2;
    protected boolean selectionVisible = true;
    protected boolean renderSelection;
    protected int headerHeight;
    protected double scroll;
    protected boolean scrolling;
    @Nullable
    protected E hoveredItem;
    protected E selectedItem;
    protected ResourceLocation backgroundLocation;

    public DynamicErrorFreeEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.backgroundLocation = backgroundLocation;
    }

    public void setRenderSelection(boolean boolean_1) {
        this.selectionVisible = boolean_1;
    }

    protected void setRenderHeader(boolean boolean_1, int headerHeight) {
        this.renderSelection = boolean_1;
        this.headerHeight = headerHeight;
        if (!boolean_1) {
            this.headerHeight = 0;
        }
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        if (this.isFocused()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hoveredItem != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
        E entry = this.hoveredItem;
        if (entry != null) {
            ((Entry)entry).updateNarration(narrationElementOutput.nest());
            this.narrateListElementPosition(narrationElementOutput, entry);
        } else {
            GuiEventListener entry2 = this.getFocused();
            if (entry2 != null) {
                entry2.updateNarration(narrationElementOutput.nest());
                this.narrateListElementPosition(narrationElementOutput, entry2);
            }
        }
        narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(NarrationElementOutput narrationElementOutput, E entry) {
        int i;
        List<E> list = this.children();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    public int getItemWidth() {
        return 220;
    }

    public E getSelectedItem() {
        return this.selectedItem;
    }

    public void selectItem(E item) {
        this.selectedItem = item;
    }

    public E getFocused() {
        return (E)((Entry)super.getFocused());
    }

    public final List<E> children() {
        return this.entries;
    }

    protected final void clearItems() {
        this.entries.clear();
    }

    protected E getItem(int index) {
        return (E)((Entry)this.children().get(index));
    }

    protected int addItem(E item) {
        this.entries.add(item);
        return this.entries.size() - 1;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelected(int index) {
        return Objects.equals(this.getSelectedItem(), this.children().get(index));
    }

    protected final E getItemAtPosition(double mouseX, double mouseY) {
        int listMiddleX = this.left + this.width / 2;
        int minX = listMiddleX - this.getItemWidth() / 2;
        int maxX = listMiddleX + this.getItemWidth() / 2;
        int currentY = Mth.floor((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScroll() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            E item = this.getItem(i);
            if ((itemY += ((Entry)item).getItemHeight()) <= currentY) continue;
            itemIndex = i;
            break;
        }
        return (E)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.getItemCount() ? (Entry)this.children().get(itemIndex) : null);
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    protected int getMaxScrollPosition() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.headerHeight;
        for (Entry entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0);
    }

    protected void clickedHeader(int int_1, int int_2) {
    }

    public static void renderBackBackground(GuiGraphics graphics, ResourceLocation backgroundLocation, int left, int top, int right, int bottom, int yOffset, int color) {
    }

    protected void drawBackground() {
    }

    protected void renderDecorations(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void renderHeader(GuiGraphics graphics, int rowLeft, int startY) {
    }

    @Deprecated
    protected void renderBackBackground(GuiGraphics graphics) {
        DynamicErrorFreeEntryListWidget.renderBackBackground(graphics, this.backgroundLocation, this.left, this.top, this.right, this.bottom, (int)this.getScroll(), 32);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawBackground();
        int scrollbarPosition = this.getScrollbarPosition();
        int int_4 = scrollbarPosition + 6;
        this.renderBackBackground(graphics);
        int rowLeft = this.getRowLeft();
        int startY = this.top + 4 - (int)this.getScroll();
        if (this.renderSelection) {
            this.renderHeader(graphics, rowLeft, startY);
        }
        this.renderList(graphics, rowLeft, startY, mouseX, mouseY, delta);
        this.renderHoleBackground(graphics, 0, this.top, 255, 255);
        this.renderHoleBackground(graphics, this.bottom, this.height, 255, 255);
        graphics.blit(RenderPipelines.GUI_TEXTURED, Screen.HEADER_SEPARATOR, this.left, this.top - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
        graphics.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, this.left, this.bottom, 0.0f, 0.0f, this.width, 2, 32, 2);
        int maxScroll = this.getMaxScroll();
        this.renderScrollBar(graphics, maxScroll, scrollbarPosition, int_4);
        this.renderDecorations(graphics, mouseX, mouseY);
    }

    protected void renderScrollBar(GuiGraphics graphics, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = Mth.clamp((int)height, (int)32, (int)(this.bottom - this.top - 8));
            int y = (int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top;
            if (y < this.top) {
                y = this.top;
            }
            int finalY = y;
            int n = height;
        }
    }

    protected void centerScrollOn(E item) {
        double d = (double)(this.bottom - this.top) / -2.0;
        for (int i = 0; i < this.children().indexOf(item) && i < this.getItemCount(); ++i) {
            d += (double)((Entry)this.getItem(i)).getItemHeight();
        }
        this.capYPosition(d);
    }

    protected void ensureVisible(E item) {
        int int_3;
        int rowTop = this.getRowTop(this.children().indexOf(item));
        int int_2 = rowTop - this.top - 4 - ((Entry)item).getItemHeight();
        if (int_2 < 0) {
            this.scroll(int_2);
        }
        if ((int_3 = this.bottom - rowTop - ((Entry)item).getItemHeight() * 2) < 0) {
            this.scroll(-int_3);
        }
    }

    protected void scroll(int int_1) {
        this.capYPosition(this.getScroll() + (double)int_1);
        this.yDrag = -2;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void capYPosition(double double_1) {
        this.scroll = Mth.clamp((double)double_1, (double)0.0, (double)this.getMaxScroll());
    }

    protected int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - (this.bottom - this.top - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScroll() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        this.updateScrollingState(event.x(), event.y(), event.button());
        if (!this.isMouseOver(event.x(), event.y())) {
            return false;
        }
        E item = this.getItemAtPosition(event.x(), event.y());
        if (item != null) {
            if (item.mouseClicked(event, doubleClick)) {
                this.setFocused((GuiEventListener)item);
                this.setDragging(true);
                return true;
            }
        } else if (event.button() == 0) {
            this.clickedHeader((int)(event.x() - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(event.y() - (double)this.top) + (int)this.getScroll() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(event);
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        if (super.mouseDragged(event, deltaX, deltaY)) {
            return true;
        }
        if (event.button() == 0 && this.scrolling) {
            if (event.y() < (double)this.top) {
                this.capYPosition(0.0);
            } else if (event.y() > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = Mth.clamp((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(this.getScroll() + deltaY * double_6);
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double double_1, double double_2, double amountX, double amountY) {
        for (Entry entry : this.entries) {
            if (!entry.mouseScrolled(double_1, double_2, amountX, amountY)) continue;
            return true;
        }
        if (amountY == 0.0) {
            return false;
        }
        this.capYPosition(this.getScroll() - amountY * (double)(this.getMaxScroll() / this.getItemCount()) / 2.0);
        return true;
    }

    public boolean keyPressed(KeyEvent event) {
        if (super.keyPressed(event)) {
            return true;
        }
        if (event.key() == 264) {
            this.moveSelection(1);
            return true;
        }
        if (event.key() == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int int_1) {
        if (!this.children().isEmpty()) {
            int int_2 = this.children().indexOf(this.getSelectedItem());
            int int_3 = Mth.clamp((int)(int_2 + int_1), (int)0, (int)(this.getItemCount() - 1));
            Entry itemListWidget$Item_1 = (Entry)this.children().get(int_3);
            this.selectItem(itemListWidget$Item_1);
            this.ensureVisible(itemListWidget$Item_1);
        }
    }

    public boolean isMouseOver(double double_1, double double_2) {
        return double_2 >= (double)this.top && double_2 <= (double)this.bottom && double_1 >= (double)this.left && double_1 <= (double)this.right;
    }

    protected void renderList(GuiGraphics graphics, int startX, int startY, int int_3, int int_4, float float_1) {
        this.hoveredItem = this.isMouseOver(int_3, int_4) ? this.getItemAtPosition(int_3, int_4) : null;
        int itemCount = this.getItemCount();
        Tesselator tessellator = Tesselator.getInstance();
        for (int renderIndex = 0; renderIndex < itemCount; ++renderIndex) {
            E item = this.getItem(renderIndex);
            int itemY = startY + this.headerHeight;
            for (int i = 0; i < this.entries.size() && i < renderIndex; ++i) {
                itemY += ((Entry)this.entries.get(i)).getItemHeight();
            }
            int itemHeight = ((Entry)item).getItemHeight() - 4;
            int itemWidth = this.getItemWidth();
            if (this.selectionVisible && this.isSelected(renderIndex)) {
                int itemMinX = this.left + this.width / 2 - itemWidth / 2;
                int itemMaxX = itemMinX + itemWidth;
                float f = this.isFocused() ? 1.0f : 0.5f;
            }
            int y = this.getRowTop(renderIndex);
            int x = this.getRowLeft();
            this.renderItem(graphics, item, renderIndex, y, x, itemWidth, itemHeight, int_3, int_4, Objects.equals(this.hoveredItem, item), float_1);
        }
    }

    protected void renderItem(GuiGraphics graphics, E item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        ((Entry)item).render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
    }

    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getItemWidth() / 2 + 2;
    }

    protected int getRowTop(int index) {
        int integer = this.top + 4 - (int)this.getScroll() + this.headerHeight;
        for (int i = 0; i < this.entries.size() && i < index; ++i) {
            integer += ((Entry)this.entries.get(i)).getItemHeight();
        }
        return integer;
    }

    public boolean isFocused() {
        return false;
    }

    protected void renderHoleBackground(GuiGraphics graphics, int y1, int y2, int alpha1, int alpha2) {
    }

    protected E remove(int int_1) {
        Entry itemListWidget$Item_1 = (Entry)this.entries.get(int_1);
        return (E)(this.removeEntry((Entry)this.entries.get(int_1)) ? itemListWidget$Item_1 : null);
    }

    protected boolean removeEntry(E itemListWidget$Item_1) {
        boolean boolean_1 = this.entries.remove(itemListWidget$Item_1);
        if (boolean_1 && itemListWidget$Item_1 == this.getSelectedItem()) {
            this.selectItem(null);
        }
        return boolean_1;
    }

    @OnlyIn(value=Dist.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final ArrayList<E> items = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public void clear() {
            this.items.clear();
        }

        @Override
        public E get(int int_1) {
            return (Entry)this.items.get(int_1);
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public E set(int int_1, E itemListWidget$Item_1) {
            Entry itemListWidget$Item_2 = (Entry)this.items.set(int_1, itemListWidget$Item_1);
            ((Entry)itemListWidget$Item_1).parent = DynamicErrorFreeEntryListWidget.this;
            return itemListWidget$Item_2;
        }

        @Override
        public void add(int int_1, E itemListWidget$Item_1) {
            this.items.add(int_1, itemListWidget$Item_1);
            ((Entry)itemListWidget$Item_1).parent = DynamicErrorFreeEntryListWidget.this;
        }

        @Override
        public E remove(int int_1) {
            return (Entry)this.items.remove(int_1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry<E extends Entry<E>>
    implements GuiEventListener {
        @Deprecated
        DynamicErrorFreeEntryListWidget<E> parent;
        @Nullable
        private NarratableEntry lastNarratable;

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean isMouseOver(double double_1, double double_2) {
            return Objects.equals(this.parent.getItemAtPosition(double_1, double_2), this);
        }

        public DynamicErrorFreeEntryListWidget<E> getParent() {
            return this.parent;
        }

        public void setParent(DynamicErrorFreeEntryListWidget<E> parent) {
            this.parent = parent;
        }

        public abstract int getItemHeight();

        @Deprecated
        public int getMorePossibleHeight() {
            return -1;
        }

        public abstract List<? extends NarratableEntry> narratables();

        void updateNarration(NarrationElementOutput narrationElementOutput) {
            List<NarratableEntry> list = this.narratables();
            Screen.NarratableSearchResult narratableSearchResult = Screen.findNarratableWidget(list, (NarratableEntry)this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.priority().isTerminal()) {
                    this.lastNarratable = narratableSearchResult.entry();
                }
                if (list.size() > 1) {
                    narrationElementOutput.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.object_list", (Object[])new Object[]{narratableSearchResult.index() + 1, list.size()}));
                    if (narratableSearchResult.priority() == NarratableEntry.NarrationPriority.FOCUSED) {
                        narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
                    }
                }
                narratableSearchResult.entry().updateNarration(narrationElementOutput.nest());
            }
        }
    }

    public static final class SmoothScrollingSettings {
        public static final double CLAMP_EXTENSION = 200.0;

        private SmoothScrollingSettings() {
        }
    }
}

