/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector3f;

public class DelegateWidgetWithTranslate
extends DelegateWidget {
    private final Supplier<Matrix3x2f> translate;

    public DelegateWidgetWithTranslate(WidgetWithBounds widget, Supplier<Matrix3x2f> translate) {
        super(widget);
        this.translate = translate;
    }

    protected Matrix3x2f translate() {
        return this.translate.get();
    }

    protected final Matrix3x2f inverseTranslate() {
        return MatrixUtils.inverse(this.translate());
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.pose().pushMatrix();
        graphics.pose().mul((Matrix3x2fc)this.translate());
        Vector3f mouse = this.transformMouse(mouseX, mouseY);
        super.render(graphics, (int)mouse.x(), (int)mouse.y(), delta);
        graphics.pose().popMatrix();
    }

    private Vector3f transformMouse(double mouseX, double mouseY) {
        Vector3f mouse = new Vector3f((float)mouseX, (float)mouseY, 1.0f);
        this.inverseTranslate().transform(mouse);
        return mouse;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        Vector3f mouse = this.transformMouse(mouseX, mouseY);
        return super.containsMouse(mouse.x(), mouse.y());
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        Vector3f mouse = this.transformMouse(event.x(), event.y());
        return super.mouseClicked(new MouseButtonEvent((double)mouse.x(), (double)mouse.y(), event.buttonInfo()), doubleClick);
    }

    @Override
    public boolean mouseReleased(MouseButtonEvent event) {
        Vector3f mouse = this.transformMouse(event.x(), event.y());
        return super.mouseReleased(new MouseButtonEvent((double)mouse.x(), (double)mouse.y(), event.buttonInfo()));
    }

    @Override
    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        Vector3f mouse = this.transformMouse(event.x(), event.y());
        return super.mouseDragged(new MouseButtonEvent((double)mouse.x(), (double)mouse.y(), event.buttonInfo()), deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        Vector3f mouse = this.transformMouse(mouseX, mouseY);
        return super.mouseScrolled(mouse.x(), mouse.y(), amountX, amountY);
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        try {
            Widget.translateMouse(this.inverseTranslate());
            boolean bl = super.keyPressed(event);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    @Override
    public boolean keyReleased(KeyEvent event) {
        try {
            Widget.translateMouse(this.inverseTranslate());
            boolean bl = super.keyReleased(event);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    @Override
    public boolean charTyped(CharacterEvent event) {
        try {
            Widget.translateMouse(this.inverseTranslate());
            boolean bl = super.charTyped(event);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    @Override
    public Rectangle getBounds() {
        return MatrixUtils.transform(this.translate(), super.getBounds());
    }
}

