/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;

public class ScreenOverlayImplForge
extends ScreenOverlayImpl {
    @Override
    public void renderTooltipInner(Screen screen, GuiGraphics graphics, Tooltip tooltip, int mouseX, int mouseY) {
        graphics.pose().pushMatrix();
        EntryStack<?> stack = tooltip.getContextStack();
        ItemStack itemStack = stack.getType() == VanillaEntryTypes.ITEM ? (ItemStack)stack.castValue() : ItemStack.EMPTY;
        List<Component> texts = CollectionUtils.filterAndMap(tooltip.entries(), Tooltip.Entry::isText, Tooltip.Entry::getAsText);
        ArrayList<ClientTooltipComponent> components = ClientHooks.gatherTooltipComponents((ItemStack)itemStack, texts, Optional.empty(), (int)mouseX, (int)screen.width, (int)screen.height, (Font)screen.getMinecraft().font);
        components = new ArrayList<ClientTooltipComponent>(components);
        for (Tooltip.Entry entry : tooltip.entries()) {
            if (entry.isText()) continue;
            TooltipComponent component = entry.getAsTooltipComponent();
            if (component instanceof ClientTooltipComponent) {
                ClientTooltipComponent client = (ClientTooltipComponent)component;
                components.add(client);
                continue;
            }
            components.add(1, ClientTooltipComponent.create((TooltipComponent)component));
        }
        Font font = Minecraft.getInstance().font;
        if (!itemStack.isEmpty()) {
            font = ClientHooks.getTooltipFont((ItemStack)itemStack, (Font)font);
        }
        graphics.tooltipStack = itemStack;
        graphics.setTooltipForNextFrameInternal(font, components, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, tooltip.getTooltipStyle(), false);
        graphics.tooltipStack = ItemStack.EMPTY;
        graphics.pose().popMatrix();
    }
}

