/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FilteringScreen
extends Screen {
    protected List<EntryStack<?>> selected = Lists.newArrayList();
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            return Mth.ceil((float)((float)FilteringScreen.this.entryStacks.size() / ((float)FilteringScreen.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize() + 28;
        }

        public Rectangle getBounds() {
            return FilteringScreen.this.getBounds();
        }

        public int getScrollBarX(int maxX) {
            return FilteringScreen.this.width - 7;
        }
    };
    Screen parent;
    private Set<EntryStack<?>> configFiltered;
    private Tooltip tooltip = null;
    private List<EntryStack<?>> entryStacks = null;
    private Rectangle innerBounds;
    private List<FilteringListEntry> entries = Collections.emptyList();
    private List<GuiEventListener> elements = Collections.emptyList();
    private List<PointPair> points = new ArrayList<PointPair>();
    private OverlaySearchField searchField;
    private Button selectAllButton;
    private Button selectNoneButton;
    private Button hideButton;
    private Button showButton;
    private Button backButton;
    private Predicate<Rectangle> selectionCache;
    private SearchFilter lastFilter = SearchFilter.matchAll();

    public FilteringScreen(Set<EntryStack<?>> configFiltered) {
        super((Component)Component.translatable((String)"config.roughlyenoughitems.filteringScreen"));
        this.configFiltered = configFiltered;
        this.searchField = new OverlaySearchField(0, 0, 0, 0);
        MutableComponent selectAllText = Component.translatable((String)"config.roughlyenoughitems.filteredEntries.selectAll");
        this.selectAllButton = Button.builder((Component)selectAllText, button -> {
            this.points.clear();
            this.points.add(new PointPair(new Point(-1073741823, -1073741823), new Point(0x3FFFFFFF, 0x3FFFFFFF)));
        }).bounds(0, 0, Minecraft.getInstance().font.width((FormattedText)selectAllText) + 10, 20).build();
        MutableComponent selectNoneText = Component.translatable((String)"config.roughlyenoughitems.filteredEntries.selectNone");
        this.selectNoneButton = Button.builder((Component)selectNoneText, button -> this.points.clear()).bounds(0, 0, Minecraft.getInstance().font.width((FormattedText)selectNoneText) + 10, 20).build();
        MutableComponent hideText = Component.translatable((String)"config.roughlyenoughitems.filteredEntries.hide");
        this.hideButton = Button.builder((Component)hideText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                FilteringListEntry entry = this.entries.get(i);
                entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
                if (!entry.isSelected() || entry.isFiltered()) continue;
                configFiltered.add(stack);
                entry.dirty = true;
            }
        }).bounds(0, 0, Minecraft.getInstance().font.width((FormattedText)hideText) + 10, 20).build();
        MutableComponent showText = Component.translatable((String)"config.roughlyenoughitems.filteredEntries.show");
        this.showButton = Button.builder((Component)showText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                FilteringListEntry entry = this.entries.get(i);
                entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
                if (!entry.isSelected() || !configFiltered.remove(stack)) continue;
                entry.dirty = true;
            }
        }).bounds(0, 0, Minecraft.getInstance().font.width((FormattedText)showText) + 10, 20).build();
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.backButton = Button.builder((Component)backText, button -> {
            this.minecraft.setScreen(this.parent);
            this.parent = null;
        }).bounds(0, 0, Minecraft.getInstance().font.width((FormattedText)backText) + 10, 20).build();
        this.searchField.isMain = false;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
        this.parent = null;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(Mth.floor((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)(width * EntryListWidget.entrySize()) / 2.0f), bounds.y + 5, width * EntryListWidget.entrySize(), bounds.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 30, this.width, this.height - 30);
    }

    public void init() {
        super.init();
        Rectangle bounds = this.getBounds();
        this.updateSearch(this.searchField.getText());
        this.selectAllButton.setX(2);
        this.selectAllButton.setY(bounds.getMaxY() - 22);
        this.selectNoneButton.setX(4 + this.selectAllButton.getWidth());
        this.selectNoneButton.setY(bounds.getMaxY() - 22);
        int searchFieldWidth = Math.max(bounds.width - (this.selectNoneButton.getX() + this.selectNoneButton.getWidth() + this.hideButton.getWidth() + this.showButton.getWidth() + 12), 100);
        this.searchField.getBounds().setBounds(this.selectNoneButton.getX() + this.selectNoneButton.getWidth() + 4, bounds.getMaxY() - 21, searchFieldWidth, 18);
        this.hideButton.setX(bounds.getMaxX() - this.hideButton.getWidth() - this.showButton.getWidth() - 4);
        this.hideButton.setY(bounds.getMaxY() - 22);
        this.showButton.setX(bounds.getMaxX() - this.showButton.getWidth() - 2);
        this.showButton.setY(bounds.getMaxY() - 22);
        this.backButton.setX(4);
        this.backButton.setY(4);
        this.searchField.setResponder(this::updateSearch);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int nextIndex;
        super.render(graphics, mouseX, mouseY, delta);
        this.updateSelectionCache();
        Rectangle bounds = this.getBounds();
        this.tooltip = null;
        UpdatedListWidget.renderAs(this.minecraft, this.width, this.height, bounds.y, this.height, graphics, delta);
        if (bounds.isEmpty()) {
            return;
        }
        graphics.enableScissor(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY());
        for (FilteringListEntry entry : this.entries) {
            entry.clearStacks();
        }
        int skip = Math.max(0, Mth.floor((double)(this.scrolling.scrollAmount() / (double)EntryListWidget.entrySize())));
        EntryRendererManager<FilteringListEntry> manager = new EntryRendererManager<FilteringListEntry>();
        for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.entryStacks.size(); ++i) {
            EntryStack<?> stack = this.entryStacks.get(i);
            FilteringListEntry entry = this.entries.get(nextIndex);
            entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
            if (entry.getBounds().y > bounds.getMaxY()) break;
            entry.entry((EntryStack)stack);
            manager.add(entry);
            ++nextIndex;
        }
        manager.render(graphics, mouseX, mouseY, delta);
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(graphics, 0, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        this.searchField.render(graphics, mouseX, mouseY, delta);
        this.selectAllButton.render(graphics, mouseX, mouseY, delta);
        this.selectNoneButton.render(graphics, mouseX, mouseY, delta);
        this.hideButton.render(graphics, mouseX, mouseY, delta);
        this.showButton.render(graphics, mouseX, mouseY, delta);
        graphics.disableScissor();
        this.backButton.render(graphics, mouseX, mouseY, delta);
        if (this.tooltip != null) {
            ((ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get()).renderTooltip(graphics, this.tooltip);
        }
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
        MutableComponent hint = Component.translatable((String)"config.roughlyenoughitems.filteringRulesScreen.hint").withStyle(ChatFormatting.YELLOW);
        graphics.drawString(this.font, (Component)hint, this.width - this.font.width((FormattedText)hint) - 15, 12, -1);
    }

    private Predicate<Rectangle> getSelection() {
        return this.selectionCache;
    }

    private void updateSelectionCache() {
        if (!this.points.isEmpty()) {
            Predicate<Rectangle> predicate = rect -> false;
            for (PointPair pair : this.points) {
                Point firstPoint = pair.firstPoint();
                Point secondPoint = pair.secondPoint();
                if (secondPoint == null) {
                    secondPoint = PointHelper.ofMouse();
                    secondPoint.translate(0, this.scrolling.scrollAmountInt());
                }
                int left = Math.min(firstPoint.x, secondPoint.x);
                int top = Math.min(firstPoint.y, secondPoint.y);
                int right = Math.max(firstPoint.x, secondPoint.x);
                int bottom = Math.max(firstPoint.y, secondPoint.y);
                Rectangle rectangle = new Rectangle(left, top - this.scrolling.scrollAmountInt(), Math.max(1, right - left), Math.max(1, bottom - top));
                predicate = predicate.or(arg_0 -> ((Rectangle)rectangle).intersects(arg_0));
            }
            this.selectionCache = predicate;
            return;
        }
        this.selectionCache = rect -> false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double dx, double dy) {
        if (this.scrolling.mouseDragged(event.x(), event.y(), event.button(), dx, dy)) {
            return true;
        }
        return super.mouseDragged(event, dx, dy);
    }

    private void updatePosition(float delta) {
        this.scrolling.updatePosition(delta);
    }

    public void updateSearch(String searchTerm) {
        this.lastFilter = SearchProvider.getInstance().createFilter(searchTerm);
        LinkedHashSet list = Sets.newLinkedHashSet();
        ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(this::matches).map(EntryStack::normalize).forEachOrdered(list::add);
        this.entryStacks = Lists.newArrayList((Iterable)list);
        this.updateEntriesPosition();
    }

    public boolean matches(EntryStack<?> stack) {
        EntrySerializer<?> serializer = stack.getDefinition().getSerializer();
        if (serializer == null) {
            return false;
        }
        return this.lastFilter.test(stack);
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        this.innerBounds = FilteringScreen.updateInnerBounds(this.getBounds());
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.entryStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add(new FilteringListEntry(xPos, yPos, entrySize));
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
        this.elements = Lists.newArrayList((Iterable)entries);
        this.elements.add((GuiEventListener)this.searchField);
    }

    public List<? extends GuiEventListener> children() {
        return this.elements;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.scrolling.updateDraggingState(event.x(), event.y(), event.button())) {
            return true;
        }
        if (this.getBounds().contains(event.x(), event.y())) {
            if (this.searchField.mouseClicked(event, doubleClick)) {
                this.points.clear();
                return true;
            }
            if (this.selectAllButton.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (this.selectNoneButton.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (this.hideButton.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (this.showButton.mouseClicked(event, doubleClick)) {
                return true;
            }
            if (event.button() == 0) {
                if (!Minecraft.getInstance().hasShiftDown()) {
                    this.points.clear();
                }
                this.points.add(new PointPair(new Point(event.x(), event.y() + this.scrolling.scrollAmount()), null));
                return true;
            }
        }
        return this.backButton.mouseClicked(event, doubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        PointPair pair;
        if (event.button() == 0 && !this.points.isEmpty() && (pair = this.points.get(this.points.size() - 1)).secondPoint() == null) {
            this.points.set(this.points.size() - 1, new PointPair(pair.firstPoint(), new Point(event.x(), event.y() + this.scrolling.scrollAmount())));
            return true;
        }
        return super.mouseReleased(event);
    }

    public boolean charTyped(CharacterEvent event) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.charTyped(event)) continue;
            return true;
        }
        return super.charTyped(event);
    }

    public boolean keyPressed(KeyEvent event) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.keyPressed(event)) continue;
            return true;
        }
        if (event.isSelectAll()) {
            this.points.clear();
            this.points.add(new PointPair(new Point(-1073741823, -1073741823), new Point(0x3FFFFFFF, 0x3FFFFFFF)));
            return true;
        }
        if (event.key() == 256 && this.shouldCloseOnEsc()) {
            this.backButton.onPress((InputWithModifiers)event);
            return true;
        }
        return false;
    }

    public void updateArea(@Nullable String searchTerm) {
        if (searchTerm != null) {
            this.updateSearch(searchTerm);
        } else if (this.entryStacks == null) {
            this.updateSearch("");
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean mouseScrolled(double double_1, double double_2, double amountX, double amountY) {
        if (this.getBounds().contains(double_1, double_2) && amountY != 0.0) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        super.mouseScrolled(double_1, double_2, amountX, amountY);
        return true;
    }

    private class FilteringListEntry
    extends EntryWidget {
        private int backupY;
        private boolean filtered;
        private boolean dirty;

        private FilteringListEntry(int x, int y, int entrySize) {
            super(new Point(x, y));
            this.filtered = false;
            this.dirty = true;
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = entrySize;
            this.interactableFavorites(false);
            this.interactable(false);
            this.noHighlight();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FilteringScreen.this.getBounds().contains(mouseX, mouseY);
        }

        @Override
        protected void drawExtra(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.isSelected()) {
                boolean filtered = this.isFiltered();
                Rectangle bounds = this.getBounds();
                graphics.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), filtered ? -1862270977 : 0x55FFFFFF, filtered ? -1862270977 : 0x55FFFFFF);
            }
        }

        public boolean isSelected() {
            return FilteringScreen.this.getSelection().test(this.getBounds());
        }

        public boolean isFiltered() {
            if (this.dirty) {
                this.filtered = FilteringScreen.this.configFiltered.contains(this.getCurrentEntry());
                this.dirty = false;
            }
            return this.filtered;
        }

        @Override
        protected void drawBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.isFiltered()) {
                Rectangle bounds = this.getBounds();
                graphics.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -65536, -65536);
            }
        }

        @Override
        protected void queueTooltip(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (FilteringScreen.this.searchField.containsMouse(mouseX, mouseY)) {
                return;
            }
            Tooltip tooltip = this.getCurrentTooltip(TooltipContext.of(new Point(mouseX, mouseY), Item.TooltipContext.of((Level)this.minecraft.level)));
            if (tooltip != null) {
                FilteringScreen.this.tooltip = tooltip;
            }
        }
    }

    private record PointPair(Point firstPoint, @Nullable Point secondPoint) {
    }
}

