/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;

public class DefaultInformationDisplay
implements Display {
    public static final DisplaySerializer<DefaultInformationDisplay> SERIALIZER = DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().fieldOf("stacks").forGetter(DefaultInformationDisplay::getEntryStacks), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(DefaultInformationDisplay::getName), (App)ComponentSerialization.CODEC.listOf().fieldOf("texts").forGetter(DefaultInformationDisplay::getTexts)).apply((Applicative)instance, (stacks, name, texts) -> new DefaultInformationDisplay((EntryIngredient)stacks, (Component)name).lines((Collection<Component>)texts))), StreamCodec.composite(EntryIngredient.streamCodec(), DefaultInformationDisplay::getEntryStacks, (StreamCodec)ComponentSerialization.STREAM_CODEC, DefaultInformationDisplay::getName, (StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), DefaultInformationDisplay::getTexts, (stacks, name, texts) -> new DefaultInformationDisplay((EntryIngredient)stacks, (Component)name).lines((Collection<Component>)texts)));
    private final EntryIngredient entryStacks;
    private final List<Component> texts;
    private final Component name;

    protected DefaultInformationDisplay(EntryIngredient entryStacks, Component name) {
        this.entryStacks = entryStacks;
        this.name = name;
        this.texts = Lists.newArrayList();
    }

    public static DefaultInformationDisplay createFromEntries(EntryIngredient entryStacks, Component name) {
        return new DefaultInformationDisplay(entryStacks, name);
    }

    public static DefaultInformationDisplay createFromEntry(EntryStack<?> entryStack, Component name) {
        return DefaultInformationDisplay.createFromEntries(EntryIngredient.of(entryStack), name);
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return Collections.singletonList(this.entryStacks);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(this.entryStacks);
    }

    public DefaultInformationDisplay line(Component line) {
        this.texts.add(line);
        return this;
    }

    public DefaultInformationDisplay lines(Component ... lines) {
        this.texts.addAll(Arrays.asList(lines));
        return this;
    }

    public DefaultInformationDisplay lines(Collection<Component> lines) {
        this.texts.addAll(lines);
        return this;
    }

    public EntryIngredient getEntryStacks() {
        return this.entryStacks;
    }

    public Component getName() {
        return this.name;
    }

    public List<Component> getTexts() {
        return this.texts;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.INFO;
    }

    @Override
    public Optional<Identifier> getDisplayLocation() {
        return Optional.empty();
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

