/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.tag;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.client.categories.tag.TagNodeWidget;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.joml.Matrix3x2f;

public class ReferenceTagNodeWidget<S, T>
extends TagNodeWidget<S, T> {
    private final TagNode<S> node;
    private final Rectangle overflowBounds;
    private final Rectangle bounds;
    private final Slot slot;
    private final List<? extends GuiEventListener> children;

    public ReferenceTagNodeWidget(TagNode<S> node, Function<Holder<S>, EntryStack<T>> mapper, Rectangle overflowBounds) {
        this.node = node;
        this.overflowBounds = overflowBounds;
        this.bounds = new Rectangle(0, 0, 24, 23);
        this.slot = Widgets.createSlot(new Rectangle(0, 0, 18, 18)).disableBackground().disableHighlight().disableTooltips().entries(EntryIngredients.ofTag((HolderGetter.Provider)BasicDisplay.registryAccess(), node.getReference(), mapper));
        this.children = Collections.singletonList(this.slot);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.overflowBounds.intersects(MatrixUtils.transform((Matrix3x2f)graphics.pose(), this.getBounds()))) {
            graphics.innerBlit(RenderPipelines.GUI_TEXTURED, Identifier.withDefaultNamespace((String)"textures/gui/sprites/advancements/task_frame_unobtained.png"), this.bounds.x - 1, this.bounds.x - 1 + 26, this.bounds.y - 1, this.bounds.y - 1 + 26, 0.0f, 1.0f, 0.0f, 1.0f, -1);
            this.slot.getBounds().setLocation(this.bounds.getCenterX() - this.slot.getBounds().getWidth() / 2, this.bounds.y + (this.bounds.height - this.slot.getBounds().getHeight()) / 2 + 1);
            this.slot.render(graphics, mouseX, mouseY, delta);
            if (this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(new Component[]{Component.literal((String)("#" + this.node.getReference().location().toString()))}).queue();
            }
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }
}

