/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.CraftingRecipeFiller;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.level.ItemLike;

public class TippedArrowRecipeFiller
implements CraftingRecipeFiller<TippedArrowRecipe> {
    @Override
    public Collection<Display> apply(RecipeHolder<TippedArrowRecipe> recipe) {
        EntryIngredient arrowStack = EntryIngredient.of(EntryStacks.of((ItemLike)Items.ARROW));
        HashSet registeredPotions = new HashSet();
        ArrayList<Display> displays = new ArrayList<Display>();
        RegistryAccess registryAccess = BasicDisplay.registryAccess();
        BasicDisplay.registryAccess().lookup(Registries.POTION).stream().flatMap(HolderLookup::listElements).map(reference -> PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)reference)).forEach(itemStack -> {
            PotionContents potion = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
            if (potion.potion().isPresent() && ((Holder)potion.potion().get()).unwrapKey().isPresent() && registeredPotions.add(((ResourceKey)((Holder)potion.potion().get()).unwrapKey().get()).identifier())) {
                int i;
                ArrayList<EntryIngredient> input = new ArrayList<EntryIngredient>();
                for (i = 0; i < 4; ++i) {
                    input.add(arrowStack);
                }
                input.add(EntryIngredients.of(itemStack));
                for (i = 0; i < 4; ++i) {
                    input.add(arrowStack);
                }
                ItemStack outputStack = new ItemStack((ItemLike)Items.TIPPED_ARROW, 8);
                outputStack.set(DataComponents.POTION_CONTENTS, (Object)potion);
                displays.add(new DefaultCustomDisplay(input, List.of(EntryIngredients.of(outputStack)), Optional.of(recipe.id().identifier())));
            }
        });
        return displays;
    }

    @Override
    public Class<TippedArrowRecipe> getRecipeClass() {
        return TippedArrowRecipe.class;
    }
}

