/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.util;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.GameInstance;
import java.lang.ref.WeakReference;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InstanceHelper {
    private static final InstanceHelper INSTANCE = new InstanceHelper();
    private WeakReference<RegistryAccess> registryAccessRef;
    private boolean warnedRegistryAccess;

    public static InstanceHelper getInstance() {
        return INSTANCE;
    }

    public RegistryAccess registryAccess() {
        RegistryAccess access;
        RegistryAccess registryAccess = access = this.registryAccessRef == null ? null : (RegistryAccess)this.registryAccessRef.get();
        if (access != null) {
            return access;
        }
        if (Platform.getEnvironment() == Env.CLIENT) {
            access = InstanceHelper.registryAccessFromClient();
        } else if (GameInstance.getServer() != null) {
            access = GameInstance.getServer().registryAccess();
        }
        if (access == null && !this.warnedRegistryAccess) {
            this.warnedRegistryAccess = true;
            InternalLogger.getInstance().throwException(new IllegalStateException("Cannot get registry access!"));
            return RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        }
        return access;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static ClientPacketListener connectionFromClient() {
        if (Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.connection;
        }
        if (Minecraft.getInstance().getConnection() != null) {
            return Minecraft.getInstance().getConnection();
        }
        if (Minecraft.getInstance().gameMode != null) {
            return Minecraft.getInstance().gameMode.connection;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RegistryAccess registryAccessFromClient() {
        ClientPacketListener connection = InstanceHelper.connectionFromClient();
        if (connection == null) {
            return null;
        }
        return connection.registryAccess();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RecipeAccess recipeAccessFromClient() {
        ClientPacketListener connection = InstanceHelper.connectionFromClient();
        if (connection == null) {
            return null;
        }
        return connection.recipes();
    }
}

