/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.settings.EntrySettingsAdapterRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import me.shedaniel.rei.impl.common.entry.TypedEntryStack;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractEntryStack<A>
implements EntryStack<A>,
Renderer {
    private static final Short2ObjectMap<Object> EMPTY_SETTINGS = Short2ObjectMaps.emptyMap();
    private Short2ObjectMap<Object> settings = null;

    @Override
    public <T> EntryStack<A> setting(EntryStack.Settings<T> settings, T value) {
        short settingsId = settings.getId();
        if (this.settings == null) {
            this.settings = Short2ObjectMaps.singleton((short)settingsId, value);
        } else {
            if (this.settings.size() == 1) {
                if (this.settings.containsKey(settingsId)) {
                    this.settings = Short2ObjectMaps.singleton((short)settingsId, value);
                    return this;
                }
                Short2ObjectMap<Object> singletonSettings = this.settings;
                this.settings = new Short2ObjectOpenHashMap(2);
                this.settings.putAll(singletonSettings);
            }
            this.settings.put(settingsId, value);
        }
        return this;
    }

    @Override
    public <T> EntryStack<A> removeSetting(EntryStack.Settings<T> settings) {
        if (this.settings != null) {
            short settingsId = settings.getId();
            if (this.settings.size() == 1) {
                if (this.settings.containsKey(settingsId)) {
                    this.settings = null;
                }
            } else if (this.settings.remove(settingsId) != null && this.settings.isEmpty()) {
                this.settings = null;
            }
        }
        return this;
    }

    @Override
    public EntryStack<A> clearSettings() {
        this.settings = null;
        return this;
    }

    protected Short2ObjectMap<Object> getSettings() {
        return this.settings == null ? EMPTY_SETTINGS : this.settings;
    }

    @Override
    @Nullable
    public Identifier getIdentifier() {
        return this.getDefinition().getIdentifier(this, this.getValue());
    }

    @Override
    @Nullable
    public String getContainingNamespace() {
        return this.get((EntryStack.Settings)EntryStack.Settings.CONTAINING_NS).apply(this, this.getDefinition().getContainingNamespace(this, this.getValue()));
    }

    @Override
    public boolean isEmpty() {
        return this.getDefinition().isEmpty(this, this.getValue());
    }

    @Override
    public EntryStack<A> copy() {
        return this.wrap(this.getDefinition().copy(this, this.getValue()), true);
    }

    @Override
    public EntryStack<A> rewrap() {
        return this.wrap(this.getValue(), true);
    }

    @Override
    public EntryStack<A> normalize() {
        return this.wrap(this.getDefinition().normalize(this, this.getValue()), false);
    }

    @Override
    public EntryStack<A> wildcard() {
        return this.wrap(this.getDefinition().wildcard(this, this.getValue()), false);
    }

    @Override
    public EntryStack<ItemStack> cheatsAs() {
        ItemStack stack = this.getDefinition().cheatsAs(this, this.getValue());
        if (stack == null) {
            return EntryStacks.of(ItemStack.EMPTY);
        }
        return EntryStacks.of(stack);
    }

    protected EntryStack<A> wrap(A value, boolean copySettings) {
        TypedEntryStack<Object> stack = new TypedEntryStack<Object>(this.getDefinition(), value);
        if (copySettings) {
            for (Short2ObjectMap.Entry entry : this.getSettings().short2ObjectEntrySet()) {
                stack.setting(EntryStack.Settings.getById(entry.getShortKey()), entry.getValue());
            }
        }
        return stack;
    }

    @Override
    public <T> T get(EntryStack.Settings<T> settings) {
        T o = this.getNullable(settings);
        if (o == null) {
            o = settings.getDefaultValue();
        }
        return o;
    }

    @Override
    @Nullable
    public <T> T getNullable(EntryStack.Settings<T> settings) {
        Object o = this.settings == null ? null : this.settings.get(settings.getId());
        o = EntrySettingsAdapterRegistry.getInstance().adapt(this, settings, o);
        return (T)o;
    }

    @Override
    public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        try {
            this.getRenderer().render(this, graphics, bounds, mouseX, mouseY, delta);
        }
        catch (Throwable throwable) {
            CrashReport report = CrashReportUtils.essential(throwable, "Rendering entry");
            CrashReportUtils.renderer(report, this);
            throw CrashReportUtils.throwReport(report);
        }
    }

    @Override
    @Nullable
    public Tooltip getTooltip(TooltipContext context, boolean appendModName) {
        try {
            MutableObject tooltip = new MutableObject((Object)this.getRenderer().cast().getTooltip(this, context));
            if (tooltip.getValue() == null) {
                return null;
            }
            ((Tooltip)tooltip.getValue()).withContextStack(this);
            ((Tooltip)tooltip.getValue()).addAllTexts((Iterable<Component>)this.get((EntryStack.Settings)EntryStack.Settings.TOOLTIP_APPEND_EXTRA).apply(this));
            tooltip.setValue((Object)this.get((EntryStack.Settings)EntryStack.Settings.TOOLTIP_PROCESSOR).apply(this, (Tooltip)tooltip.getValue()));
            if (tooltip.getValue() == null) {
                return null;
            }
            String containingNs = this.getContainingNamespace();
            if (appendModName) {
                if (containingNs != null) {
                    ClientHelper.getInstance().appendModIdToTooltips((Tooltip)tooltip.getValue(), containingNs);
                }
            } else if (containingNs != null) {
                String modName = ClientHelper.getInstance().getModFromModId(containingNs);
                Iterator<Tooltip.Entry> iterator = ((Tooltip)tooltip.getValue()).entries().iterator();
                while (iterator.hasNext()) {
                    Tooltip.Entry s = iterator.next();
                    if (!s.isText() || !FormattingUtils.stripFormatting(s.getAsText().getString()).equalsIgnoreCase(modName)) continue;
                    iterator.remove();
                }
            }
            return (Tooltip)tooltip.getValue();
        }
        catch (Throwable throwable) {
            if (context.isSearch()) {
                throw throwable;
            }
            CrashReport report = CrashReportUtils.essential(throwable, "Getting tooltips");
            CrashReportUtils.renderer(report, this);
            throw CrashReportUtils.throwReport(report);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractEntryStack)) {
            return false;
        }
        AbstractEntryStack that = (AbstractEntryStack)o;
        return EntryStacks.equalsExact(this, that);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(EntryStacks.hashExact(this));
    }

    @Override
    public Stream<TagKey<?>> getTagsFor() {
        return this.getDefinition().getTagsFor(this, this.getValue());
    }

    @Override
    public Component asFormattedText() {
        return this.getDefinition().asFormattedText(this, this.getValue(), TooltipContext.of(Item.TooltipContext.EMPTY));
    }

    @Override
    public Component asFormattedText(TooltipContext context) {
        return this.getDefinition().asFormattedText(this, this.getValue(), context);
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category) {
        EntryStack.super.fillCrashReport(report, category);
        category.setDetail("Entry type", () -> String.valueOf(this.getType().getId()));
        category.setDetail("Is empty", () -> String.valueOf(this.isEmpty()));
        category.setDetail("Entry identifier", () -> String.valueOf(this.getIdentifier()));
        CrashReportCategory rendererCategory = report.addCategory("Entry Renderer");
        try {
            this.getDefinition().fillCrashReport(report, rendererCategory, this);
        }
        catch (Throwable throwable) {
            rendererCategory.setDetailError("Filling Report", throwable);
        }
    }
}

