/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.view;

import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.client.view.Views;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilterCalculator;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.registry.display.DisplayCache;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ViewsImpl
implements Views {
    private static final ThreadLocal<ViewSearchBuilder> BUILDER = new ThreadLocal();

    @Override
    @Nullable
    public ViewSearchBuilder getContext() {
        return BUILDER.get();
    }

    public static Map<DisplayCategory<?>, List<DisplaySpec>> buildMapFor(ViewSearchBuilder builder) {
        BUILDER.set(builder);
        try {
            Map<DisplayCategory<?>, List<DisplaySpec>> map = ViewsImpl._buildMapFor(builder);
            return map;
        }
        finally {
            BUILDER.remove();
        }
    }

    private static Map<DisplayCategory<?>, List<DisplaySpec>> _buildMapFor(ViewSearchBuilder builder) {
        if (PluginManager.areAnyReloading()) {
            InternalLogger.getInstance().info("Cancelled Views buildMap since plugins have not finished reloading.");
            return Maps.newLinkedHashMap();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean processingVisibilityHandlers = builder.isProcessingVisibilityHandlers();
        HashSet categories = new HashSet(builder.getCategories());
        Set<CategoryIdentifier<?>> filteringCategories = builder.getFilteringCategories();
        List<EntryStack<?>> recipesForStacks = builder.getRecipesFor();
        List<EntryStack<?>> usagesForStacks = builder.getUsagesFor();
        Function<EntryStack, Collection> wildcardFunction = stack -> {
            EntryStack wildcard = stack.wildcard();
            if (EntryStacks.equalsFuzzy(wildcard, stack)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(wildcard);
        };
        List recipesForStacksWildcard = CollectionUtils.flatMap(recipesForStacks, wildcardFunction);
        List usagesForStacksWildcard = CollectionUtils.flatMap(usagesForStacks, wildcardFunction);
        DisplayRegistry displayRegistry = DisplayRegistry.getInstance();
        DisplayCache displayCache = ((DisplayRegistryImpl)displayRegistry).cache();
        HashMap result = Maps.newHashMap();
        ViewsImpl.forCategories(processingVisibilityHandlers, filteringCategories, displayRegistry, result, (configuration, categoryId, displays, set) -> {
            if (categories.contains(categoryId)) {
                for (Display display : displays) {
                    if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(configuration.getCategory(), display)) continue;
                    set.add(display);
                }
                if (!set.isEmpty()) {
                    ViewsImpl.getOrPutEmptyLinkedSet(result, configuration.getCategory()).addAll((Collection)set);
                }
                return;
            }
            for (Display display : displays) {
                if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(configuration.getCategory(), display)) continue;
                if (!recipesForStacks.isEmpty() && ViewsImpl.isRecipesFor(displayCache, recipesForStacks, display)) {
                    set.add(display);
                    continue;
                }
                if (usagesForStacks.isEmpty() || !ViewsImpl.isUsagesFor(displayCache, usagesForStacks, display)) continue;
                set.add(display);
            }
        });
        int generatorsCount = 0;
        for (Map.Entry<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> entry : displayRegistry.getCategoryDisplayGenerators().entrySet()) {
            CategoryIdentifier<?> categoryIdentifier = entry.getKey();
            DisplayCategory<?> category = CategoryRegistry.getInstance().get(categoryIdentifier).getCategory();
            if (processingVisibilityHandlers && CategoryRegistry.getInstance().isCategoryInvisible(category) || !filteringCategories.isEmpty() && !filteringCategories.contains(categoryIdentifier)) continue;
            LinkedHashSet set2 = new LinkedHashSet();
            generatorsCount += entry.getValue().size();
            for (DynamicDisplayGenerator<?> generator : entry.getValue()) {
                ViewsImpl.generateLiveDisplays(displayRegistry, ViewsImpl.wrapForError(generator), builder, set2::add);
            }
            if (set2.isEmpty()) continue;
            ViewsImpl.getOrPutEmptyLinkedSet(result, category).addAll(set2);
        }
        Consumer<Display> displayConsumer = display -> {
            CategoryIdentifier<?> categoryIdentifier = display.getCategoryIdentifier();
            if (!filteringCategories.isEmpty() && !filteringCategories.contains(categoryIdentifier)) {
                return;
            }
            ViewsImpl.getOrPutEmptyLinkedSet(result, CategoryRegistry.getInstance().get(categoryIdentifier).getCategory()).add(display);
        };
        for (DynamicDisplayGenerator<?> dynamicDisplayGenerator : displayRegistry.getGlobalDisplayGenerators()) {
            ++generatorsCount;
            ViewsImpl.generateLiveDisplays(displayRegistry, ViewsImpl.wrapForError(dynamicDisplayGenerator), builder, displayConsumer);
        }
        if (!(!CollectionUtils.allMatch(result.values(), Set::isEmpty) || recipesForStacksWildcard.isEmpty() && usagesForStacksWildcard.isEmpty())) {
            ViewsImpl.forCategories(processingVisibilityHandlers, filteringCategories, displayRegistry, result, (configuration, categoryId, displays, set) -> {
                if (categories.contains(categoryId)) {
                    return;
                }
                for (Display display : displays) {
                    if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(configuration.getCategory(), display)) continue;
                    if (!recipesForStacksWildcard.isEmpty() && ViewsImpl.isRecipesFor(displayCache, recipesForStacksWildcard, display)) {
                        set.add(display);
                        continue;
                    }
                    if (usagesForStacksWildcard.isEmpty() || !ViewsImpl.isUsagesFor(displayCache, usagesForStacksWildcard, display)) continue;
                    set.add(display);
                }
            });
        }
        ViewsImpl.forCategories(processingVisibilityHandlers, filteringCategories, displayRegistry, result, (configuration, categoryId, displays, set) -> {
            if (categories.contains(categoryId)) {
                return;
            }
            for (EntryStack usagesFor : Iterables.concat((Iterable)usagesForStacks, (Iterable)usagesForStacksWildcard)) {
                if (!ViewsImpl.isStackWorkStationOfCategory(configuration, usagesFor)) continue;
                categories.add((CategoryIdentifier<?>)categoryId);
                if (processingVisibilityHandlers) {
                    set.addAll(CollectionUtils.filterToSet(displays, display -> displayRegistry.isDisplayVisible(configuration.getCategory(), (Display)display)));
                    break;
                }
                set.addAll(displays);
                break;
            }
        });
        Stopwatch stopwatch2 = Stopwatch.createStarted();
        Stopwatch stopwatch3 = Stopwatch.createUnstarted();
        LinkedHashMap merged = new LinkedHashMap();
        for (Map.Entry entry : result.entrySet()) {
            merged.put((DisplayCategory)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        if (builder.isMergingDisplays() && ConfigObject.getInstance().doMergeDisplayUnderOne()) {
            ViewsImpl.mergeAndOptimize(result, merged);
        }
        stopwatch2.stop();
        stopwatch3.start();
        Map<DisplayCategory<?>, List<DisplaySpec>> sorted = ViewsImpl.sortDisplays(merged);
        stopwatch3.stop();
        String string = String.format("Built Recipe View in %s for %d categories, %d recipes for, %d usages for and %d live recipe generators.", stopwatch.stop(), categories.size(), recipesForStacks.size(), usagesForStacks.size(), generatorsCount);
        if (ConfigObject.getInstance().doDebugSearchTimeRequired()) {
            InternalLogger.getInstance().info(string);
        } else {
            InternalLogger.getInstance().trace(string);
        }
        return sorted;
    }

    private static Map<DisplayCategory<?>, List<DisplaySpec>> sortDisplays(Map<DisplayCategory<?>, List<DisplaySpec>> unsorted) {
        Object2IntOpenHashMap categoryOrder = new Object2IntOpenHashMap();
        categoryOrder.defaultReturnValue(Integer.MAX_VALUE);
        int i = 100000;
        for (CategoryRegistry.CategoryConfiguration categoryConfiguration : CategoryRegistry.getInstance()) {
            categoryOrder.put(categoryConfiguration.getCategoryIdentifier(), i++);
        }
        i = 0;
        for (CategoryIdentifier categoryIdentifier : ConfigObject.getInstance().getCategoryOrdering()) {
            categoryOrder.put((Object)categoryIdentifier, i++);
        }
        TreeMap result = new TreeMap(Comparator.comparingInt(arg_0 -> ViewsImpl.lambda$sortDisplays$6((Object2IntMap)categoryOrder, arg_0)));
        result.putAll(unsorted);
        return result;
    }

    private static void forCategories(boolean processingVisibilityHandlers, Set<CategoryIdentifier<?>> filteringCategories, DisplayRegistry displayRegistry, Map<DisplayCategory<?>, Set<Display>> result, QuadConsumer<CategoryRegistry.CategoryConfiguration<?>, CategoryIdentifier<?>, List<Display>, Set<Display>> displayConsumer) {
        for (CategoryRegistry.CategoryConfiguration configuration : CategoryRegistry.getInstance()) {
            if (processingVisibilityHandlers && CategoryRegistry.getInstance().isCategoryInvisible(configuration.getCategory())) continue;
            CategoryIdentifier<?> categoryId = configuration.getCategoryIdentifier();
            if (!filteringCategories.isEmpty() && !filteringCategories.contains(categoryId)) continue;
            List<?> allRecipesFromCategory = displayRegistry.get(categoryId);
            LinkedHashSet set = new LinkedHashSet();
            displayConsumer.accept(configuration, categoryId, allRecipesFromCategory, set);
            if (set.isEmpty()) continue;
            ViewsImpl.getOrPutEmptyLinkedSet(result, configuration.getCategory()).addAll(set);
        }
    }

    public static <A, B> Set<B> getOrPutEmptyLinkedSet(Map<A, Set<B>> map, A key) {
        Set<B> b = map.get(key);
        if (b != null) {
            return b;
        }
        map.put(key, (Set<B>)new ReferenceLinkedOpenHashSet());
        return map.get(key);
    }

    public static boolean isRecipesFor(@Nullable DisplayCache displayCache, List<EntryStack<?>> stacks, Display display) {
        Iterator<EntryStack<?>> iterator;
        if (displayCache != null && displayCache.isCached(display) && (iterator = stacks.iterator()).hasNext()) {
            EntryStack<?> recipesFor = iterator.next();
            return displayCache.getDisplaysByOutput(recipesFor).contains(display);
        }
        return ViewsImpl.checkUsages(stacks, display, display.getOutputEntries());
    }

    public static boolean isUsagesFor(@Nullable DisplayCache displayCache, List<EntryStack<?>> stacks, Display display) {
        Iterator<EntryStack<?>> iterator;
        if (displayCache != null && displayCache.isCached(display) && (iterator = stacks.iterator()).hasNext()) {
            EntryStack<?> recipesFor = iterator.next();
            return displayCache.getDisplaysByInput(recipesFor).contains(display);
        }
        return ViewsImpl.checkUsages(stacks, display, display.getInputEntries());
    }

    private static boolean checkUsages(List<EntryStack<?>> stacks, Display display, List<EntryIngredient> entries) {
        for (EntryIngredient results : entries) {
            for (EntryStack otherEntry : results) {
                for (EntryStack<?> recipesFor : stacks) {
                    if (!EntryStacks.equalsFuzzy(otherEntry, recipesFor)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Iterable<Display> sortAutoCrafting(Iterable<Display> displays) {
        LinkedHashSet<Display> successfulDisplays = new LinkedHashSet<Display>();
        LinkedHashSet<Display> applicableDisplays = new LinkedHashSet<Display>();
        for (Display display2 : displays) {
            AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, display2, null);
            if (result.successful) {
                successfulDisplays.add(display2);
                continue;
            }
            if (!result.hasApplicable) continue;
            applicableDisplays.add(display2);
        }
        return Iterables.concat(successfulDisplays, applicableDisplays, (Iterable)Iterables.filter(displays, display -> !successfulDisplays.contains(display) && !applicableDisplays.contains(display)));
    }

    private static <T extends Display> void generateLiveDisplays(DisplayRegistry displayRegistry, DynamicDisplayGenerator<T> generator, ViewSearchBuilder builder, Consumer<T> displayConsumer) {
        boolean processingVisibilityHandlers = builder.isProcessingVisibilityHandlers();
        for (EntryStack<?> stack : builder.getRecipesFor()) {
            Optional<List<T>> recipeForDisplays = generator.getRecipeFor(stack);
            if (!recipeForDisplays.isPresent()) continue;
            for (Display display : recipeForDisplays.get()) {
                if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        for (EntryStack<?> stack : builder.getUsagesFor()) {
            Optional<List<T>> usageForDisplays = generator.getUsageFor(stack);
            if (!usageForDisplays.isPresent()) continue;
            for (Display display : usageForDisplays.get()) {
                if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
        Optional<List<T>> displaysGenerated = generator.generate(builder);
        if (displaysGenerated.isPresent()) {
            for (Display display : displaysGenerated.get()) {
                if (processingVisibilityHandlers && !displayRegistry.isDisplayVisible(display)) continue;
                displayConsumer.accept(display);
            }
        }
    }

    private static <T extends Display> DynamicDisplayGenerator<T> wrapForError(final DynamicDisplayGenerator<T> generator) {
        return new DynamicDisplayGenerator<T>(){

            @Override
            public Optional<List<T>> getRecipeFor(EntryStack<?> entry) {
                try {
                    return generator.getRecipeFor(entry);
                }
                catch (Throwable throwable) {
                    CrashReport report = CrashReportUtils.essential(throwable, "Error while generating recipes for an entry stack");
                    CrashReportUtils.renderer(report, entry);
                    InternalLogger.getInstance().throwException((Throwable)new ReportedException(report));
                    return Optional.empty();
                }
            }

            @Override
            public Optional<List<T>> getUsageFor(EntryStack<?> entry) {
                try {
                    return generator.getUsageFor(entry);
                }
                catch (Throwable throwable) {
                    CrashReport report = CrashReportUtils.essential(throwable, "Error while generating usages for an entry stack");
                    CrashReportUtils.renderer(report, entry);
                    InternalLogger.getInstance().throwException((Throwable)new ReportedException(report));
                    return Optional.empty();
                }
            }

            @Override
            public Optional<List<T>> generate(ViewSearchBuilder builder) {
                try {
                    return generator.generate(builder);
                }
                catch (Throwable throwable) {
                    CrashReport report = CrashReportUtils.essential(throwable, "Error while generating recipes for a search");
                    InternalLogger.getInstance().throwException((Throwable)new ReportedException(report));
                    return Optional.empty();
                }
            }
        };
    }

    public Predicate<HashedEntryStackWrapper> getCraftableEntriesPredicate() {
        if (PluginManager.areAnyReloading()) {
            return Predicates.alwaysTrue();
        }
        return new CraftableFilterCalculator();
    }

    private static <T> boolean isStackWorkStationOfCategory(CategoryRegistry.CategoryConfiguration<?> category, EntryStack<T> stack) {
        for (EntryIngredient ingredient : category.getWorkstations()) {
            if (!EntryIngredients.testFuzzy(ingredient, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startReload() {
    }

    private static void mergeAndOptimize(Map<DisplayCategory<?>, Set<Display>> displays, Map<DisplayCategory<?>, List<DisplaySpec>> resultSpec) {
        for (Map.Entry<DisplayCategory<?>, Set<Display>> entry : displays.entrySet()) {
            DisplayMerger<Display> merger = entry.getKey().getDisplayMerger();
            if (merger == null) continue;
            LinkedHashMap<WrappedDisplaySpec, WrappedDisplaySpec> wrappedSet = new LinkedHashMap<WrappedDisplaySpec, WrappedDisplaySpec>();
            ArrayList<WrappedDisplaySpec> specs = new ArrayList<WrappedDisplaySpec>();
            for (Display display : ViewsImpl.sortAutoCrafting((Iterable<Display>)entry.getValue())) {
                WrappedDisplaySpec wrapped = new WrappedDisplaySpec(merger, display);
                if (wrappedSet.containsKey(wrapped)) {
                    ((WrappedDisplaySpec)wrappedSet.get(wrapped)).add(display);
                    continue;
                }
                wrappedSet.put(wrapped, wrapped);
                specs.add(wrapped);
            }
            resultSpec.put(entry.getKey(), specs);
        }
    }

    private static /* synthetic */ int lambda$sortDisplays$6(Object2IntMap categoryOrder, DisplayCategory category) {
        return categoryOrder.getInt(category.getCategoryIdentifier());
    }

    @FunctionalInterface
    private static interface QuadConsumer<P1, P2, P3, P4> {
        public void accept(P1 var1, P2 var2, P3 var3, P4 var4);
    }

    private static class WrappedDisplaySpec
    implements DisplaySpec {
        private final DisplayMerger<Display> merger;
        private final Display display;
        private List<Identifier> ids = null;
        private final int hash;

        public WrappedDisplaySpec(DisplayMerger<Display> merger, Display display) {
            this.merger = merger;
            this.display = display;
            this.hash = merger.hashOf(display);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WrappedDisplaySpec)) {
                return false;
            }
            WrappedDisplaySpec wrapped = (WrappedDisplaySpec)o;
            return this.hash == wrapped.hash && this.merger.canMerge(this.display, wrapped.display);
        }

        public int hashCode() {
            return this.hash;
        }

        @Override
        public Display provideInternalDisplay() {
            return this.display;
        }

        @Override
        public Collection<Identifier> provideInternalDisplayIds() {
            if (this.ids == null) {
                this.ids = new ArrayList<Identifier>();
                Optional<Identifier> location = this.display.getDisplayLocation();
                if (location.isPresent()) {
                    this.ids.add(location.get());
                }
            }
            return this.ids;
        }

        public void add(Display display) {
            Optional<Identifier> location = display.getDisplayLocation();
            if (location.isPresent()) {
                this.provideInternalDisplayIds().add(location.get());
            }
        }
    }
}

