/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.search.argument.Argument;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.util.ThreadCreator;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.util.Util;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class ArgumentCache {
    public static final ExecutorService EXECUTOR_SERVICE = new ThreadCreator("REI-Cache").asService(2);
    private final Short2ObjectMap<Long2ObjectMap<Object>> cache = Short2ObjectMaps.synchronize((Short2ObjectMap)new Short2ObjectOpenHashMap());
    public Long prepareStart = null;
    public List<HashedEntryStackWrapper> prepareStacks = null;
    public CurrentStep currentStep = null;

    public Long2ObjectMap<Object> getSearchCache(ArgumentType<?, ?> argumentType) {
        short argumentIndex = (short)argumentType.getIndex();
        Long2ObjectMap map = (Long2ObjectMap)this.cache.get(argumentIndex);
        if (map == null) {
            map = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
            this.cache.put(argumentIndex, (Object)map);
        }
        return map;
    }

    public void prepareFilter(Collection<HashedEntryStackWrapper> stacks, Collection<ArgumentType<?, ?>> argumentTypes) {
        this.prepareFilter(stacks, argumentTypes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareFilter(Collection<HashedEntryStackWrapper> stacks, Collection<ArgumentType<?, ?>> argumentTypes, @Nullable Executor executor) {
        if (this.currentStep != null) {
            return;
        }
        try {
            this.prepareStart = Util.getEpochMillis();
            List<Long2ObjectMap> caches = CollectionUtils.map(argumentTypes, this::getSearchCache);
            this.prepareStacks = CollectionUtils.filterToList(stacks, stack -> {
                for (Long2ObjectMap cache : caches) {
                    if (cache.containsKey(stack.hashExact())) continue;
                    return true;
                }
                return false;
            });
            if (this.prepareStacks.isEmpty()) {
                return;
            }
            InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Preparing " + this.prepareStacks.size() * argumentTypes.size() + " stacks for search arguments");
            this.currentStep = new CurrentStep(0, argumentTypes.size());
            int searchPartitionSize = ConfigObject.getInstance().getAsyncSearchPartitionSize();
            boolean async = ConfigObject.getInstance().shouldAsyncSearch() && this.prepareStacks.size() > searchPartitionSize * 4;
            this.cache(argumentTypes, async ? executor : Runnable::run);
        }
        finally {
            this.prepareStart = null;
            this.prepareStacks = null;
            this.currentStep = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void cache(Collection<ArgumentType<?, ?>> argumentTypes, @Nullable Executor executor) {
        int searchPartitionSize = ConfigObject.getInstance().getAsyncSearchPartitionSize();
        ArrayList futures = Lists.newArrayList();
        int[] sum = new int[]{0};
        for (ArgumentType<?, ?> argumentType : argumentTypes) {
            Long2ObjectMap<Object> cacheMap = this.getSearchCache(argumentType);
            CurrentStep.Step currentStage = this.currentStep.steps[this.currentStep.step] = new CurrentStep.Step(0, this.prepareStacks.size());
            ++this.currentStep.step;
            for (Collection partitionStacks : CollectionUtils.partition(this.prepareStacks, searchPartitionSize)) {
                futures.add(CompletableFuture.supplyAsync(() -> ArgumentCache.cacheStacks(argumentType, cacheMap, partitionStacks), Objects.requireNonNullElse(executor, EXECUTOR_SERVICE)).whenComplete((map, throwable) -> {
                    if (map != null) {
                        currentStage.stacks += map.size();
                        cacheMap.putAll((Map)map);
                        sum[0] = sum[0] + map.size();
                    }
                }));
            }
        }
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(90L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            e.printStackTrace();
            InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + sum[0] + " / " + this.prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.getEpochMillis() - this.prepareStart) + "ms");
        }
        catch (InterruptedException interruptedException) {
            InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + sum[0] + " / " + this.prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.getEpochMillis() - this.prepareStart) + "ms");
            {
                catch (Throwable throwable2) {
                    InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + sum[0] + " / " + this.prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.getEpochMillis() - this.prepareStart) + "ms");
                    throw throwable2;
                }
            }
        }
        InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + sum[0] + " / " + this.prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.getEpochMillis() - this.prepareStart) + "ms");
    }

    private static Long2ObjectMap<Object> cacheStacks(ArgumentType<?, ?> argumentType, Long2ObjectMap<Object> cacheMap, Collection<HashedEntryStackWrapper> stacks) {
        Long2ObjectArrayMap out = new Long2ObjectArrayMap(stacks.size() + 1);
        for (HashedEntryStackWrapper stack : stacks) {
            if (cacheMap.get(stack.hashExact()) != null) continue;
            try {
                Object data = argumentType.cacheData(stack.unwrap());
                out.put(stack.hashExact(), data == null ? Argument.NO_CACHE : data);
            }
            catch (Throwable throwable) {}
        }
        return out;
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public static class CurrentStep {
        public int step;
        public final int totalSteps;
        public final Step[] steps;

        public CurrentStep(int step, int totalSteps) {
            this.step = step;
            this.totalSteps = totalSteps;
            this.steps = new Step[totalSteps];
        }

        public static class Step {
            public int stacks;
            public int totalStacks;

            public Step(int stacks, int totalStacks) {
                this.stacks = stacks;
                this.totalStacks = totalStacks;
            }
        }
    }
}

