/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.panel;

import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;

public abstract class FadingFavoritesPanelButton
extends WidgetWithBounds {
    protected final FavoritesListWidget parent;
    public boolean wasClicked = false;
    public final NumberAnimator<Double> alpha = ValueAnimator.ofDouble((double)0.0);
    public final Rectangle bounds = new Rectangle();

    public FadingFavoritesPanelButton(FavoritesListWidget parent) {
        this.parent = parent;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.bounds.setBounds(this.updateArea(this.parent.favoritesBounds));
        boolean hovered = this.containsMouse(mouseX, mouseY);
        switch (ConfigObject.getInstance().getFavoriteAddWidgetMode()) {
            case ALWAYS_INVISIBLE: {
                this.alpha.setAs(0);
                break;
            }
            case AUTO_HIDE: {
                this.alpha.setTo(hovered ? 1.0f : (this.isAvailable(mouseX, mouseY) ? 0.5f : 0.0f), ConfigObject.getInstance().isReducedMotion() ? 0L : 260L);
                break;
            }
            case ALWAYS_VISIBLE: {
                this.alpha.setAs(hovered ? 1.0f : 0.5f);
            }
        }
        this.alpha.update((double)delta);
        int buttonColor = 0xFFFFFF | Math.round(116.0f * this.alpha.floatValue()) << 24;
        graphics.fillGradient(this.bounds.x, this.bounds.y, this.bounds.getMaxX(), this.bounds.getMaxY(), buttonColor, buttonColor);
        if (this.isVisible()) {
            this.renderButtonText(graphics);
        }
        if (hovered) {
            this.queueTooltip();
        }
    }

    protected abstract boolean isAvailable(int var1, int var2);

    protected abstract void renderButtonText(GuiGraphics var1);

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isVisible() {
        return Math.round(18.0f * this.alpha.floatValue()) > 0;
    }

    protected boolean wasClicked() {
        boolean tmp = this.wasClicked;
        this.wasClicked = false;
        return tmp;
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.isVisible() && this.containsMouse(event.x(), event.y())) {
            this.wasClicked = true;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.wasClicked() && this.isVisible() && this.containsMouse(event.x(), event.y())) {
            this.onClick();
            return true;
        }
        return false;
    }

    protected abstract void onClick();

    protected abstract void queueTooltip();

    protected abstract Rectangle updateArea(Rectangle var1);
}

