/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.math.Color;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListSearchManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;

public class EntryHighlighter {
    public static void render(GuiGraphics graphics) {
        float dimOpacity = (float)ConfigManagerImpl.getInstance().getConfig().functionality.inventoryHighlightingDarkenOpacity;
        float opacity = (float)ConfigManagerImpl.getInstance().getConfig().functionality.inventoryHighlightingOpacity;
        int dimColor = Color.ofRGBA((float)0.078431375f, (float)0.078431375f, (float)0.078431375f, (float)dimOpacity).getColor();
        int borderColor = Color.ofRGBA((float)0.37254903f, (float)1.0f, (float)0.23137255f, (float)opacity).getColor();
        int color = Color.ofRGBA((float)0.37254903f, (float)1.0f, (float)0.23137255f, (float)(opacity * 52.0f / 255.0f)).getColor();
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            int x = containerScreen.leftPos;
            int y = containerScreen.topPos;
            for (Slot slot : containerScreen.getMenu().slots) {
                if (!slot.hasItem() || !EntryListSearchManager.INSTANCE.matches(EntryStacks.of(slot.getItem()))) {
                    graphics.fillGradient(x + slot.x, y + slot.y, x + slot.x + 16, y + slot.y + 16, dimColor, dimColor);
                    continue;
                }
                graphics.fillGradient(x + slot.x, y + slot.y, x + slot.x + 16, y + slot.y + 16, color, color);
                graphics.fillGradient(x + slot.x - 1, y + slot.y - 1, x + slot.x, y + slot.y + 16 + 1, borderColor, borderColor);
                graphics.fillGradient(x + slot.x + 16, y + slot.y - 1, x + slot.x + 16 + 1, y + slot.y + 16 + 1, borderColor, borderColor);
                graphics.fillGradient(x + slot.x - 1, y + slot.y - 1, x + slot.x + 16, y + slot.y, borderColor, borderColor);
                graphics.fillGradient(x + slot.x - 1, y + slot.y + 16, x + slot.x + 16, y + slot.y + 16 + 1, borderColor, borderColor);
            }
        }
    }
}

