/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen.collapsible;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.ProgressValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.CollapsibleEntriesScreen;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import me.shedaniel.rei.impl.client.gui.widget.EntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class CollapsibleEntryWidget
extends WidgetWithBounds {
    private final boolean custom;
    private final Identifier id;
    private final Component component;
    private final Collection<Slot> stacks;
    private final CollapsibleConfigManager.CollapsibleConfigObject configObject;
    private final ProgressValueAnimator<Boolean> idDrawer = ValueAnimator.ofBoolean();
    private final ProgressValueAnimator<Boolean> modIdDrawer = ValueAnimator.ofBoolean();
    private final Button toggleButton;
    @Nullable
    private final Button deleteButton;
    @Nullable
    private final Button configureButton;
    private final ScrollingContainer scroller = new ScrollingContainer(){

        public Rectangle getBounds() {
            return new Rectangle(CollapsibleEntryWidget.this.x + CollapsibleEntryWidget.this.width / 2 - 8 * CollapsibleEntryWidget.this.rowSize, CollapsibleEntryWidget.this.y + 37, 16 * CollapsibleEntryWidget.this.rowSize, CollapsibleEntryWidget.this.height - 40);
        }

        public int getMaxScrollHeight() {
            return Math.max(0, Mth.positiveCeilDiv((int)CollapsibleEntryWidget.this.stacks.size(), (int)CollapsibleEntryWidget.this.rowSize) * 16) + 24;
        }
    };
    private int x;
    private int y;
    private int width;
    private int height;
    private int rowSize;

    public CollapsibleEntryWidget(boolean custom, Identifier id, Component component, Collection<EntryStack<?>> stacks, CollapsibleConfigManager.CollapsibleConfigObject configObject, Runnable markDirty) {
        this.custom = custom;
        this.id = id;
        this.component = component;
        this.stacks = CollectionUtils.map(stacks, stack -> Widgets.createSlot(new Rectangle(0, 0, 16, 16)).entry((EntryStack<?>)stack).disableBackground());
        this.configObject = configObject;
        this.toggleButton = new Button.Plain(this, 0, 0, 20, 20, (Component)Component.translatable((String)"text.rei.collapsible.entries.toggle"), button -> {
            if (this.configObject.disabledGroups.contains(this.id)) {
                this.configObject.disabledGroups.remove(this.id);
            } else {
                this.configObject.disabledGroups.add(this.id);
            }
        }, Supplier::get){};
        this.toggleButton.setWidth(this.font.width((FormattedText)this.toggleButton.getMessage()) + 8);
        if (this.custom) {
            this.deleteButton = new Button.Plain(this, 0, 0, 20, 20, (Component)Component.translatable((String)"text.rei.collapsible.entries.delete"), button -> {
                this.configObject.customGroups.removeIf(customEntry -> customEntry.id.equals((Object)this.id));
                markDirty.run();
            }, Supplier::get){};
            this.deleteButton.setWidth(this.font.width((FormattedText)this.deleteButton.getMessage()) + 8);
            this.configureButton = new Button.Plain(this, 0, 0, 20, 20, Component.nullToEmpty(null), button -> CollapsibleEntriesScreen.setupCustom(this.id, this.component.getString(), new ArrayList(stacks), this.configObject, markDirty), Supplier::get){

                protected void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    graphics.blit(RenderPipelines.GUI_TEXTURED, InternalTextures.CHEST_GUI_TEXTURE, this.getX() + 3, this.getY() + 3, 0.0f, 0.0f, 14, 14, 256, 256);
                }
            };
        } else {
            this.deleteButton = null;
            this.configureButton = null;
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.rowSize = Math.max(1, (width - 6) / 16);
            this.height = Math.min(42 + Math.max(Mth.positiveCeilDiv((int)this.stacks.size(), (int)this.rowSize) * 16 + 24, 24), 170);
        }
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Rectangle lineBounds;
        this.scroller.updatePosition(delta);
        this.idDrawer.update((double)delta);
        this.modIdDrawer.update((double)delta);
        Rectangle bounds = this.getBounds();
        graphics.fillGradient(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -8947849, -8947849);
        graphics.fillGradient(bounds.x + 1, bounds.y + 1, bounds.getMaxX() - 1, bounds.getMaxY() - 1, -15395563, -15395563);
        int y = bounds.y + 4;
        if (y + 9 >= 30 && y < this.minecraft.screen.height) {
            this.renderTextScrolling(graphics, this.component, bounds.x + 4, y, bounds.width - 8, -2236963);
        }
        if ((y += 13) + 9 >= 30 && y < this.minecraft.screen.height) {
            lineBounds = new Rectangle(bounds.x + 4, y, bounds.width - 8, 9);
            this.idDrawer.setTo((Object)lineBounds.contains(mouseX, mouseY), ConfigObject.getInstance().isReducedMotion() ? 0L : 400L);
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(graphics, lineBounds);){
                graphics.pose().pushMatrix();
                graphics.pose().translate(0.0f, (float)(-this.idDrawer.progress() * 10.0));
                graphics.drawString(this.font, (Component)Component.translatable((String)"text.rei.collapsible.entries.count", (Object[])new Object[]{"" + this.stacks.size()}), bounds.x + 4, y, -5592406);
                boolean enabled = !this.configObject.disabledGroups.contains(this.id);
                MutableComponent sideText = Component.translatable((String)("text.rei.collapsible.entries.enabled." + enabled));
                graphics.drawString(this.font, (Component)sideText, bounds.getMaxX() - 4 - this.font.width((FormattedText)sideText), y, enabled ? -581566635 : -570469035);
                this.renderTextScrolling(graphics, (Component)Component.literal((String)this.id.toString()), bounds.x + 4, y + 10, bounds.width - 8, -8947849);
                graphics.pose().popMatrix();
            }
        }
        if ((y += 10) + 9 >= 30 && y < this.minecraft.screen.height) {
            lineBounds = new Rectangle(bounds.x + 4, y, bounds.width - 8, 9);
            this.modIdDrawer.setTo((Object)lineBounds.contains(mouseX, mouseY), ConfigObject.getInstance().isReducedMotion() ? 0L : 400L);
            graphics.drawString(this.font, (Component)Component.translatable((String)"text.rei.collapsible.entries.source").append(" "), bounds.x + 4, y, -5592406);
            int xo = bounds.x + 4 + this.font.width((FormattedText)Component.translatable((String)"text.rei.collapsible.entries.source").append(" "));
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(graphics, lineBounds);){
                graphics.pose().pushMatrix();
                if (this.custom) {
                    this.renderTextScrolling(graphics, TextTransformations.applyRainbow(Component.translatable((String)"text.rei.collapsible.entries.source.custom").getVisualOrderText(), xo - 1, y), xo - 1, y, bounds.getWidth() - 8, -5592406);
                } else {
                    graphics.pose().translate(0.0f, (float)(-this.modIdDrawer.progress() * 10.0));
                    this.renderTextScrolling(graphics, (Component)Component.literal((String)ClientHelper.getInstance().getModFromModId(this.id.getNamespace())), xo - 1, y, bounds.getMaxX() - 4 - (xo - 1), -8947849);
                    this.renderTextScrolling(graphics, (Component)Component.literal((String)this.id.getNamespace().toString()), xo - 1, y + 10, bounds.getMaxX() - 4 - (xo - 1), -8947849);
                }
                graphics.pose().popMatrix();
            }
        }
        this.renderStacks(graphics, mouseX, mouseY, delta, bounds, y);
        bounds.y = this.y;
        this.toggleButton.setX(bounds.getMaxX() - 4 - this.toggleButton.getWidth());
        this.toggleButton.setY(bounds.getMaxY() - 4 - this.toggleButton.getHeight());
        this.toggleButton.render(graphics, mouseX, mouseY, delta);
        if (this.toggleButton.isMouseOver((double)mouseX, (double)mouseY)) {
            ScreenOverlayImpl.getInstance().clearTooltips();
        }
        if (this.custom) {
            this.deleteButton.setX(this.toggleButton.getX() - 2 - this.deleteButton.getWidth());
            this.deleteButton.setY(bounds.getMaxY() - 4 - this.deleteButton.getHeight());
            this.deleteButton.render(graphics, mouseX, mouseY, delta);
            if (this.deleteButton.isMouseOver((double)mouseX, (double)mouseY)) {
                ScreenOverlayImpl.getInstance().clearTooltips();
            }
            this.configureButton.setX(this.deleteButton.getX() - 2 - this.configureButton.getWidth());
            this.configureButton.setY(bounds.getMaxY() - 4 - this.configureButton.getHeight());
            this.configureButton.render(graphics, mouseX, mouseY, delta);
            if (this.configureButton.isMouseOver((double)mouseX, (double)mouseY)) {
                ScreenOverlayImpl.getInstance().clearTooltips();
            }
        }
    }

    private void renderStacks(GuiGraphics graphics, int mouseX, int mouseY, float delta, Rectangle bounds, int y) {
        try (CloseableScissors outerScissors = CollapsibleEntryWidget.scissor(graphics, new Rectangle(bounds.x, y, bounds.width, bounds.getMaxY() - 3 - y));){
            y = bounds.y + 37 - this.scroller.scrollAmountInt();
            int x = bounds.getCenterX() - 8 * this.rowSize;
            int xIndex = 0;
            EntryRendererManager<EntryWidget> manager = new EntryRendererManager<EntryWidget>();
            for (Slot stack : this.stacks) {
                if (y + 16 >= 30 && y + 16 >= bounds.y + 37) {
                    stack.getBounds().setBounds(x + 16 * xIndex - 1, y - 1, 18, 18);
                    manager.add((EntryWidget)stack);
                }
                if (++xIndex < this.rowSize) continue;
                xIndex = 0;
                if ((y += 16) < bounds.getMaxY() && y < this.minecraft.screen.height) continue;
                break;
            }
            try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(graphics, new Rectangle(x, bounds.y + 37, 16 * this.rowSize, bounds.getMaxY() - 4 - (bounds.y + 37)));){
                manager.render(graphics, mouseX, mouseY, delta);
            }
            if (this.stacks.size() > this.rowSize * 3) {
                graphics.fillGradient(this.x + 1, this.y + this.height - 40, this.x + this.width - 1, this.y + this.height - 1, 0, -16777216);
            }
        }
    }

    private void renderTextScrolling(GuiGraphics graphics, Component text, int x, int y, int width, int color) {
        this.renderTextScrolling(graphics, text.getVisualOrderText(), x, y, width, color);
    }

    private void renderTextScrolling(GuiGraphics graphics, FormattedCharSequence text, int x, int y, int width, int color) {
        try (CloseableScissors scissors = CollapsibleEntryWidget.scissor(graphics, new Rectangle(x, y, width, y + 9));){
            int textWidth = this.font.width(text);
            if (textWidth > width) {
                graphics.pose().pushMatrix();
                float textX = (float)(System.currentTimeMillis() % (long)((textWidth + 10) * textWidth / 3)) / (float)textWidth * 3.0f;
                graphics.pose().translate(-textX, 0.0f);
                graphics.drawString(this.font, text, x + width - textWidth - 10, y, color);
                graphics.drawString(this.font, text, x + width, y, color);
                graphics.pose().popMatrix();
            } else {
                graphics.drawString(this.font, text, x, y, color);
            }
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.scroller.getMaxScroll() > 0 && this.scroller.getBounds().contains(mouseX, mouseY) && amountY != 0.0 && (amountY < 0.0 || this.scroller.scrollAmountInt() != 0) && (amountY > 0.0 || this.scroller.scrollAmountInt() != this.scroller.getMaxScroll())) {
            this.scroller.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        return false;
    }

    public List<? extends GuiEventListener> children() {
        if (this.custom) {
            return List.of(this.toggleButton, this.deleteButton, this.configureButton);
        }
        return List.of(this.toggleButton);
    }
}

