/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ConfigReloadingScreen
extends Screen {
    private final Component title;
    private final BooleanSupplier predicate;
    private Supplier<@Nullable Component> subtitle = () -> null;
    private final Runnable parent;
    private final Runnable cancel;

    public ConfigReloadingScreen(Component title, BooleanSupplier predicate, Runnable parent, Runnable cancel) {
        super((Component)Component.empty());
        this.title = title;
        this.predicate = predicate;
        this.parent = parent;
        this.cancel = cancel;
    }

    public void setSubtitle(Supplier<@Nullable Component> subtitle) {
        this.subtitle = subtitle;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void init() {
        super.init();
        if (this.cancel == null) {
            return;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.cancel.run()).bounds(this.width / 2 - 100, this.height / 4 + 120 + 12, 200, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int height;
        if (!this.predicate.getAsBoolean()) {
            this.parent.run();
            return;
        }
        super.render(graphics, mouseX, mouseY, delta);
        String text = switch ((int)(Util.getMillis() / 300L % 4L)) {
            case 1, 3 -> "o O o";
            case 2 -> "o o O";
            default -> "O o o";
        };
        Component subtitle = this.subtitle.get();
        int width = Math.max(this.font.width(text), this.font.width((FormattedText)this.title));
        int n = height = subtitle == null ? 18 : 27;
        if (subtitle != null) {
            width = Math.max(width, this.font.width((FormattedText)subtitle));
        }
        int x = this.width / 2 - width / 2;
        int k = x - 12;
        int l = this.height / 2 - height / 2 - 12;
        int m = width + 24;
        int n2 = height + 24;
        int o = this.isFocused() ? -1 : -6250336;
        graphics.fill(k + 1, l, k + m, l + n2, -16777216);
        graphics.renderOutline(k, l, m, n2, o);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, l + 12, -1);
        graphics.drawCenteredString(this.font, text, this.width / 2, l + 12 + 9, -8355712);
        if (subtitle != null) {
            graphics.drawCenteredString(this.font, subtitle, this.width / 2, l + 12 + 9 + 9, -8355712);
        }
    }
}

