/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.Nullable;

public class MenuHolder
implements MenuAccess {
    public final List<Runnable> afterRenders = Lists.newArrayList();
    @Nullable
    private OverlayMenu menu = null;

    @Override
    public boolean isOpened(UUID uuid) {
        return this.menu != null && this.menu.uuid.equals(uuid);
    }

    @Override
    public boolean isAnyOpened() {
        return this.menu != null;
    }

    @Override
    public boolean isInBounds(UUID uuid) {
        return this.isOpened(uuid) && this.menu.inBounds.test(PointHelper.ofMouse());
    }

    private void proceedOpenMenu(UUID uuid, Runnable runnable) {
        this.proceedOpenMenuOrElse(uuid, runnable, menu -> {});
    }

    private void proceedOpenMenuOrElse(UUID uuid, Runnable runnable, Consumer<OverlayMenu> orElse) {
        if (this.menu == null || !this.menu.uuid.equals(uuid)) {
            this.close();
            runnable.run();
        } else {
            orElse.accept(this.menu);
        }
    }

    @Override
    public void open(UUID uuid, Menu menu) {
        this.open(uuid, menu, point -> false, point -> true);
    }

    @Override
    public void open(UUID uuid, Menu menu, Predicate<Point> or, Predicate<Point> and) {
        this.menu = new OverlayMenu(uuid, menu, menu, or, and);
    }

    @Override
    public boolean isValidPoint(Point point) {
        return ScreenOverlayImpl.getInstance().isNotInExclusionZones(point.x, point.y);
    }

    @Override
    public void close() {
        this.menu = null;
    }

    public void afterRender() {
        for (Runnable runnable : this.afterRenders) {
            runnable.run();
        }
        this.afterRenders.clear();
    }

    @Nullable
    public Widget widget() {
        return this.menu != null ? this.menu.wrappedMenu : null;
    }

    public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.menu != null) {
            if (!this.menu.inBounds.test(PointHelper.ofMouse())) {
                this.close();
            } else {
                if (this.menu.wrappedMenu.containsMouse(mouseX, mouseY)) {
                    ScreenOverlayImpl.getInstance().clearTooltips();
                }
                this.menu.wrappedMenu.render(graphics, mouseX, mouseY, delta);
            }
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        return this.menu != null && this.menu.wrappedMenu.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    private static class OverlayMenu {
        private UUID uuid;
        private Menu menu;
        private Widget wrappedMenu;
        private Predicate<Point> inBounds;

        public OverlayMenu(UUID uuid, Menu menu, Widget wrappedMenu, Predicate<Point> or, Predicate<Point> and) {
            this.uuid = uuid;
            this.menu = menu;
            this.wrappedMenu = wrappedMenu;
            this.inBounds = or.or(menu::containsMouse).and(and);
        }
    }
}

