/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.credits;

import com.google.common.collect.Lists;
import dev.architectury.platform.Platform;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.impl.client.gui.credits.CreditsEntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CreditsScreen
extends Screen {
    private Screen parent;
    private AbstractButton buttonDone;
    private CreditsEntryListWidget entryListWidget;

    public CreditsScreen(Screen parent) {
        super((Component)Component.literal((String)""));
        this.parent = parent;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 256 && this.shouldCloseOnEsc()) {
            this.openPrevious();
            return true;
        }
        return super.keyPressed(event);
    }

    public void init() {
        this.entryListWidget = new CreditsEntryListWidget(this.minecraft, this.width, this.height, 32, this.height - 32);
        this.addWidget((GuiEventListener)this.entryListWidget);
        this.entryListWidget.creditsClearEntries();
        ArrayList translators = Lists.newArrayList();
        Exception[] exception = new Exception[]{null};
        CreditsScreen.fillTranslators(exception, translators);
        List translatorsMapped = translators.stream().map(pair -> new Tuple((Object)("  " + (I18n.exists((String)("language.roughlyenoughitems." + ((String)pair.getA()).toLowerCase(Locale.ROOT).replace(' ', '_'))) ? I18n.get((String)("language.roughlyenoughitems." + ((String)pair.getA()).toLowerCase(Locale.ROOT).replace(' ', '_')), (Object[])new Object[0]) : (String)pair.getA())), (Object)((List)pair.getB()))).collect(Collectors.toList());
        int i = this.width - 80 - 6;
        for (String line : String.format("\u00a7lRoughly Enough Items (v%s)\n\u00a77Originally a fork for Almost Enough Items.\n\n\u00a7lLanguage Translation\n%s\n\n\u00a7lLicense\n\u00a77Roughly Enough Items is licensed under MIT.", Platform.getMod((String)"roughlyenoughitems").getVersion(), "%translators%").split("\n")) {
            if (line.equalsIgnoreCase("%translators%")) {
                if (exception[0] != null) {
                    this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.literal((String)("Failed to get translators: " + exception[0].toString()))));
                    for (StackTraceElement traceElement : exception[0].getStackTrace()) {
                        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.literal((String)("  at " + String.valueOf(traceElement)))));
                    }
                    continue;
                }
                int maxWidth = translatorsMapped.stream().mapToInt(pair -> this.font.width((String)pair.getA())).max().orElse(0) + 5;
                for (Tuple pair2 : translatorsMapped) {
                    MutableComponent text = Component.literal((String)"");
                    boolean isFirst = true;
                    for (TranslatorEntry entry : (List)pair2.getB()) {
                        if (!isFirst) {
                            text = text.append((Component)Component.literal((String)", "));
                        }
                        isFirst = false;
                        MutableComponent component = Component.literal((String)entry.getName());
                        if (entry.proofreader) {
                            component = component.withStyle(ChatFormatting.GOLD);
                        }
                        text = text.append((Component)component);
                    }
                    this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TranslationCreditsItem((Component)Component.translatable((String)((String)pair2.getA())), (Component)text, i - maxWidth - 10, maxWidth));
                }
                continue;
            }
            this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.literal((String)line)));
        }
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.empty()));
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem((Component)Component.literal((String)"Visit the project at GitHub."), "https://www.github.com/shedaniel/RoughlyEnoughItems", this.entryListWidget.getItemWidth(), false));
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem((Component)Component.literal((String)"Visit the project page at CurseForge."), "https://www.curseforge.com/minecraft/mc-mods/roughly-enough-items", this.entryListWidget.getItemWidth(), false));
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem((Component)Component.literal((String)"Support the project via Patreon!"), "https://patreon.com/shedaniel", this.entryListWidget.getItemWidth(), true));
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.empty()));
        this.buttonDone = new Button.Plain(this, this.width / 2 - 100, this.height - 26, 200, 20, (Component)Component.translatable((String)"gui.done"), button -> this.openPrevious(), Supplier::get){};
        this.addRenderableWidget((GuiEventListener)this.buttonDone);
    }

    private static void fillTranslators(Exception[] exception, List<Tuple<String, List<TranslatorEntry>>> translators) {
        try {
            Class.forName("me.shedaniel.rei.impl.client.gui.credits.%s.CreditsScreenImpl".formatted(Platform.isForge() ? "forge" : "fabric")).getDeclaredMethod("fillTranslators", Exception[].class, List.class).invoke(null, exception, translators);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void openPrevious() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.entryListWidget.mouseScrolled(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, I18n.get((String)"text.rei.credits", (Object[])new Object[0]), this.width / 2, 16, -1);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.renderBackground(graphics, mouseX, mouseY, delta);
        this.entryListWidget.render(graphics, mouseX, mouseY, delta);
    }

    public static class TranslatorEntry {
        private final String name;
        private final boolean proofreader;

        public TranslatorEntry(String name) {
            this(name, false);
        }

        public TranslatorEntry(String name, boolean proofreader) {
            this.name = name;
            this.proofreader = proofreader;
        }

        public String getName() {
            return this.name;
        }
    }
}

