/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.credits;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CreditsEntryListWidget
extends UpdatedListWidget<CreditsItem> {
    private boolean inFocus;

    public CreditsEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY);
    }

    public void creditsClearEntries() {
        this.clearItems();
    }

    private CreditsItem rei_getEntry(int index) {
        return (CreditsItem)((Object)this.children().get(index));
    }

    public void creditsAddEntry(CreditsItem entry) {
        this.addItem((DynamicEntryListWidget.Entry)entry);
    }

    public int getItemWidth() {
        return this.width - 80;
    }

    protected int getScrollbarPosition() {
        return this.width - 40;
    }

    public static abstract class CreditsItem
    extends UpdatedListWidget.Entry<CreditsItem> {
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        public void setFocused(boolean bl) {
        }

        public boolean isFocused() {
            return false;
        }
    }

    public static class LinkItem
    extends CreditsItem {
        private Component text;
        private List<FormattedCharSequence> textSplit;
        private String link;
        private boolean contains;
        private boolean rainbow;

        public LinkItem(Component text, String link, int width, boolean rainbow) {
            this.text = text;
            this.textSplit = Minecraft.getInstance().font.split((FormattedText)text, width);
            this.link = link;
            this.rainbow = rainbow;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                graphics.setTooltipForNextFrame(Minecraft.getInstance().font, (Component)Component.literal((String)"Click to open link."), mouseX, mouseY);
                int yy = y;
                for (FormattedCharSequence textSp : this.textSplit) {
                    FormattedCharSequence underlined = characterVisitor -> textSp.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.applyFormat(ChatFormatting.UNDERLINE), codePoint));
                    if (this.rainbow) {
                        underlined = TextTransformations.applyRainbow(underlined, x + 5, yy);
                    }
                    graphics.drawString(Minecraft.getInstance().font, underlined, x + 5, yy, -14695425);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (FormattedCharSequence textSp : this.textSplit) {
                    if (this.rainbow) {
                        textSp = TextTransformations.applyRainbow(textSp, x + 5, yy);
                    }
                    graphics.drawString(Minecraft.getInstance().font, textSp, x + 5, yy, -14695425);
                    yy += 12;
                }
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            if (this.contains && event.button() == 0) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                try {
                    Util.getPlatform().openUri(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    public static class TranslationCreditsItem
    extends CreditsItem {
        private Component language;
        private List<FormattedCharSequence> translators;
        private int maxWidth;

        public TranslationCreditsItem(Component language, Component translators, int width, int maxWidth) {
            this.language = language;
            this.translators = Minecraft.getInstance().font.split((FormattedText)translators, width);
            this.maxWidth = maxWidth;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            graphics.drawString(Minecraft.getInstance().font, this.language.getVisualOrderText(), x + 5, y + 5, -1);
            int yy = y + 5;
            for (FormattedCharSequence translator : this.translators) {
                graphics.drawString(Minecraft.getInstance().font, translator, x + 5 + this.maxWidth, yy, -1);
                yy += 12;
            }
        }

        public int getItemHeight() {
            return 12 * this.translators.size();
        }
    }

    public static class TextCreditsItem
    extends CreditsItem {
        private Component text;

        public TextCreditsItem(Component text) {
            this.text = text;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            graphics.drawString(Minecraft.getInstance().font, this.text.getVisualOrderText(), x + 5, y + 5, -1);
        }

        public int getItemHeight() {
            return 12;
        }
    }
}

