/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.options.preview;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigOptions;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class TooltipPreviewer {
    public static WidgetWithBounds create(ConfigAccess access, int width, @Nullable IntSupplier height) {
        Rectangle bounds = new Rectangle();
        return Widgets.withBounds(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            EntryStack<ItemStack> stack = EntryStacks.of((ItemLike)Items.OAK_PLANKS);
            boolean appendModNames = access.get(AllREIConfigOptions.APPEND_MOD_NAMES);
            boolean appendFavorites = access.get(AllREIConfigOptions.APPEND_FAVORITES_HINT);
            ArrayList<Tooltip.Entry> entries = new ArrayList<Tooltip.Entry>();
            entries.add(Tooltip.entry((Component)ConfigUtils.translatable("block.minecraft.oak_planks")));
            if (appendModNames) {
                entries.add(Tooltip.entry((Component)ConfigUtils.literal("Minecraft").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
            }
            if (appendFavorites) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                entries.addAll(Stream.of(I18n.get((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(ConfigUtils::literal).map(Tooltip::entry).toList());
            }
            List components = entries.stream().flatMap(entry -> Minecraft.getInstance().font.split((FormattedText)entry.getAsText(), width - 12 - 4).stream()).toList();
            int minWidth = components.stream().mapToInt(component -> Minecraft.getInstance().font.width(component)).max().orElse(0) + 4;
            int minHeight = components.stream().mapToInt(component -> components.get(0) == component && components.size() >= 2 ? 12 : 10).sum() + 4;
            int tX = Math.max(6, (width - minWidth) / 2);
            int tWidth = Math.min(width - 12, minWidth);
            int tY = 28;
            int tHeight = Math.min(minHeight, height == null ? 100000 : height.getAsInt() - tY - 4);
            graphics.pose().pushMatrix();
            graphics.pose().translate(0.0f, height == null ? 4.0f : (float)Math.max(0, (height.getAsInt() - (tY + tHeight)) / 2));
            bounds.setSize(width, height == null ? tY + tHeight + 12 : height.getAsInt());
            stack.getRenderer().render(stack, graphics, new Rectangle(width / 2 - 12, 0, 24, 24), mouseX, mouseY, delta);
            int finalTY = tY;
            graphics.fillGradient(tX - 3, finalTY - 4, tX + tWidth + 3, finalTY - 3, -267386864, -267386864);
            graphics.fillGradient(tX - 3, finalTY + tHeight + 3, tX + tWidth + 3, finalTY + tHeight + 4, -267386864, -267386864);
            graphics.fillGradient(tX - 3, finalTY - 3, tX + tWidth + 3, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.fillGradient(tX - 4, finalTY - 3, tX - 3, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.fillGradient(tX + tWidth + 3, finalTY - 3, tX + tWidth + 4, finalTY + tHeight + 3, -267386864, -267386864);
            graphics.fillGradient(tX - 3, finalTY - 3 + 1, tX - 3 + 1, finalTY + tHeight + 3 - 1, 0x505000FF, 1344798847);
            graphics.fillGradient(tX + tWidth + 2, finalTY - 3 + 1, tX + tWidth + 3, finalTY + tHeight + 3 - 1, 0x505000FF, 1344798847);
            graphics.fillGradient(tX - 3, finalTY - 3, tX + tWidth + 3, finalTY - 3 + 1, 0x505000FF, 0x505000FF);
            graphics.fillGradient(tX - 3, finalTY + tHeight + 2, tX + tWidth + 3, finalTY + tHeight + 3, 1344798847, 1344798847);
            for (int i = 0; i < components.size(); ++i) {
                graphics.drawString(Minecraft.getInstance().font, (FormattedCharSequence)components.get(i), tX + 2, tY + 2, -1, false);
                tY += 10 + (i == 0 ? 2 : 0);
            }
            graphics.pose().popMatrix();
        }), bounds);
    }

    private static void fillGradient(Matrix4f pose, VertexConsumer buffer, int x1, int y1, int x2, int y2, int blitOffset, int color1, int color2) {
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float g = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float h = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float i = (float)(color1 & 0xFF) / 255.0f;
        float j = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float k = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float l = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float m = (float)(color2 & 0xFF) / 255.0f;
        buffer.addVertex((Matrix4fc)pose, (float)x2, (float)y1, (float)blitOffset).setColor(g, h, i, f);
        buffer.addVertex((Matrix4fc)pose, (float)x1, (float)y1, (float)blitOffset).setColor(g, h, i, f);
        buffer.addVertex((Matrix4fc)pose, (float)x1, (float)y2, (float)blitOffset).setColor(k, l, m, j);
        buffer.addVertex((Matrix4fc)pose, (float)x2, (float)y2, (float)blitOffset).setColor(k, l, m, j);
    }
}

