/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.components;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.REIConfigScreen;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.config.options.OptionValueEntry;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import org.joml.Matrix3x2f;

public class ConfigOptionValueWidget {
    public static <T> WidgetWithBounds create(ConfigAccess access, CompositeOption<T> option, int width) {
        Font font = Minecraft.getInstance().font;
        Component[] text = new Component[]{null};
        Consumer<Component> setText = t -> {
            if (access.getFocusedKeycode() == option) {
                text[0] = ConfigUtils.literal("> ").withStyle(ChatFormatting.YELLOW).append((Component)t.copy().withStyle(ChatFormatting.YELLOW)).append((Component)ConfigUtils.literal(" <").withStyle(ChatFormatting.YELLOW));
            } else if (!(option.getEntry() instanceof OptionValueEntry.Configure) && access.get(option).equals(Objects.requireNonNullElseGet(option.getDefaultValue(), () -> access.getDefault(option)))) {
                text[0] = ConfigUtils.translatable("config.rei.value.default", t);
                if (font.width((FormattedText)text[0]) > width) {
                    int trimTo = width - font.width("...") - (font.width((FormattedText)text[0]) - font.width((FormattedText)t));
                    FormattedText trimmed = font.substrByWidth((FormattedText)t, trimTo);
                    FormattedText composite = FormattedText.composite((FormattedText[])new FormattedText[]{trimmed, ConfigUtils.literal("...")});
                    text[0] = ConfigUtils.literal(composite.getString());
                    text[0] = ConfigUtils.translatable("config.rei.value.default", text[0]);
                }
            } else if (font.width((FormattedText)t) > width) {
                int trimTo = width - font.width("...");
                FormattedText trimmed = font.substrByWidth((FormattedText)t, trimTo);
                FormattedText composite = FormattedText.composite((FormattedText[])new FormattedText[]{trimmed, ConfigUtils.literal("...")});
                text[0] = ConfigUtils.literal(composite.getString());
            } else {
                text[0] = t;
            }
        };
        setText.accept(option.getEntry().getOption(access.get(option)));
        Label label = Widgets.createLabel(new Point(), text[0]).rightAligned().color(-2039584).hoveredColor(-2039584).onRender((poses, l) -> {
            if (MatrixUtils.transform((Matrix3x2f)poses.pose(), l.getBounds()).contains(PointHelper.ofMouse())) {
                l.setMessage((FormattedText)text[0].copy().withStyle(ChatFormatting.UNDERLINE));
            } else {
                l.setMessage((FormattedText)text[0]);
            }
        });
        OptionValueEntry<T> optionValueEntry = option.getEntry();
        if (optionValueEntry instanceof OptionValueEntry.Selection) {
            OptionValueEntry.Selection selection = (OptionValueEntry.Selection)optionValueEntry;
            ConfigOptionValueWidget.applySelection(access, option, selection, label, setText);
        } else if (access.get(option) instanceof ModifierKeyCode) {
            ConfigOptionValueWidget.applyKeycode(access, option, label, setText);
        } else if (option.getEntry() instanceof OptionValueEntry.Configure) {
            label.clickable().onClick($ -> ((OptionValueEntry.Configure)option.getEntry()).configure(access, option, () -> {
                Minecraft.getInstance().setScreen((Screen)access);
                setText.accept(option.getEntry().getOption(access.get(option)));
            }));
        }
        return Widgets.concatWithBounds(() -> new Rectangle(-label.getBounds().width, 0, label.getBounds().width + 8, 14), label, Widgets.withTranslate(Widgets.createTexturedWidget(Identifier.parse((String)"roughlyenoughitems:textures/gui/config/selector.png"), new Rectangle(1, 1, 4, 6), 0.0f, 0.0f, 1, 1, 1, 1), 0.0, 0.5));
    }

    private static <T> void applySelection(ConfigAccess access, CompositeOption<T> option, OptionValueEntry.Selection<T> selection, Label label, Consumer<Component> setText) {
        Rectangle bounds = new Rectangle();
        BiConsumer<GuiGraphics, Label> render = label.getOnRender();
        label.onRender((poses, $) -> {
            render.accept((GuiGraphics)poses, (Label)$);
            bounds.setBounds(MatrixUtils.transform((Matrix3x2f)poses.pose(), label.getBounds()));
        });
        int noOfOptions = selection.getOptions().size();
        if (noOfOptions == 2) {
            label.clickable().onClick($ -> {
                access.set(option, selection.getOptions().get((selection.getOptions().indexOf(access.get(option)) + 1) % 2));
                setText.accept(selection.getOption(access.get(option)));
            });
        } else if (noOfOptions >= 2) {
            label.clickable().onClick($ -> {
                Menu menu = new Menu(bounds, CollectionUtils.map(selection.getOptions(), opt -> {
                    Component selectionOption = selection.getOption(opt);
                    if (opt.equals(access.getDefault(option))) {
                        selectionOption = ConfigUtils.translatable("config.rei.value.default", selectionOption);
                    }
                    return ToggleMenuEntry.of(selectionOption, () -> false, o -> {
                        ((REIConfigScreen)Minecraft.getInstance().screen).closeMenu();
                        access.set(option, opt);
                        setText.accept(selection.getOption(opt));
                    });
                }), false);
                access.closeMenu();
                access.openMenu(menu);
            });
        }
    }

    private static <T> void applyKeycode(ConfigAccess access, CompositeOption<T> option, Label label, Consumer<Component> setText) {
        label.clickable().onClick($ -> {
            access.closeMenu();
            access.focusKeycode(option);
        });
        BiConsumer<GuiGraphics, Label> render = label.getOnRender();
        label.onRender((poses, $) -> {
            render.accept((GuiGraphics)poses, (Label)$);
            setText.accept(((ModifierKeyCode)access.get(option)).getLocalizedName());
        });
    }
}

