/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;

public class ConfigureCategoriesScreen
extends Screen {
    private final Map<CategoryIdentifier<?>, Boolean> filteringQuickCraftCategories;
    private final Set<CategoryIdentifier<?>> hiddenCategories;
    private final List<CategoryIdentifier<?>> categoryOrdering;
    private ListWidget listWidget;
    public Runnable editedSink = () -> {};
    public Screen parent;

    public ConfigureCategoriesScreen(Map<CategoryIdentifier<?>, Boolean> filteringQuickCraftCategories, Set<CategoryIdentifier<?>> hiddenCategories, List<CategoryIdentifier<?>> categoryOrdering) {
        super((Component)Component.translatable((String)"config.roughlyenoughitems.configureCategories.title"));
        this.filteringQuickCraftCategories = filteringQuickCraftCategories;
        this.hiddenCategories = hiddenCategories;
        this.categoryOrdering = categoryOrdering;
        for (CategoryRegistry.CategoryConfiguration configuration : CategoryRegistry.getInstance()) {
            if (this.categoryOrdering.contains(configuration.getCategoryIdentifier())) continue;
            this.categoryOrdering.add(configuration.getCategoryIdentifier());
        }
    }

    public Map<CategoryIdentifier<?>, Boolean> getFilteringQuickCraftCategories() {
        return this.filteringQuickCraftCategories;
    }

    public Set<CategoryIdentifier<?>> getHiddenCategories() {
        return this.hiddenCategories;
    }

    public List<CategoryIdentifier<?>> getCategoryOrdering() {
        return this.categoryOrdering;
    }

    public void init() {
        super.init();
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.addRenderableWidget((GuiEventListener)new Button.Plain(this, 4, 4, Minecraft.getInstance().font.width((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.minecraft.setScreen(this.parent);
            this.parent = null;
        }, Supplier::get){});
        this.listWidget = (ListWidget)this.addWidget((GuiEventListener)new ListWidget(this.minecraft, this.width, this.height, 30, this.height));
        this.resetListEntries();
    }

    public void resetListEntries() {
        this.listWidget.children().clear();
        ArrayList configurations = new ArrayList(CategoryRegistry.getInstance().stream().toList());
        configurations.sort(Comparator.comparingInt(o -> {
            int indexOf = this.categoryOrdering.indexOf(o.getCategoryIdentifier());
            return indexOf == -1 ? Integer.MAX_VALUE : indexOf;
        }));
        for (CategoryRegistry.CategoryConfiguration categoryConfiguration : configurations) {
            this.listWidget.addItem(new DefaultListEntry(categoryConfiguration));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.listWidget.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private static class ListWidget
    extends UpdatedListWidget<ListEntry> {
        private boolean inFocus;

        public ListWidget(Minecraft client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }

        protected boolean isSelected(int index) {
            return false;
        }

        public ListEntry getSelectedItem() {
            return null;
        }

        protected int addItem(ListEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            if (super.mouseClicked(event, doubleClick)) {
                return true;
            }
            ListEntry item = (ListEntry)this.getItemAtPosition(event.x(), event.y());
            if (item != null) {
                this.client.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.selectItem((DynamicEntryListWidget.Entry)item);
                this.setFocused((GuiEventListener)item);
                this.setDragging(true);
                return true;
            }
            return false;
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    private class DefaultListEntry
    extends ListEntry {
        private final Label visibilityToggleButton;
        private final Label quickCraftToggleButton;
        private final Button upButton;
        private final Button downButton;
        private final CategoryRegistry.CategoryConfiguration<?> configuration;

        public DefaultListEntry(CategoryRegistry.CategoryConfiguration<?> configuration) {
            this.configuration = configuration;
            MutableComponent toggleText = Component.translatable((String)"config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure.toggle");
            this.visibilityToggleButton = Widgets.createClickableLabel(new Point(), (Component)toggleText, $ -> {
                boolean enabled;
                boolean bl = enabled = !ConfigureCategoriesScreen.this.hiddenCategories.contains(configuration.getCategoryIdentifier());
                if (enabled) {
                    ConfigureCategoriesScreen.this.hiddenCategories.add(configuration.getCategoryIdentifier());
                } else {
                    ConfigureCategoriesScreen.this.hiddenCategories.remove(configuration.getCategoryIdentifier());
                }
                ConfigureCategoriesScreen.this.editedSink.run();
            }).leftAligned();
            this.quickCraftToggleButton = Widgets.createClickableLabel(new Point(), (Component)toggleText, $ -> {
                boolean quickCraftingEnabledByDefault = configuration.isQuickCraftingEnabledByDefault();
                boolean enabled = ConfigureCategoriesScreen.this.filteringQuickCraftCategories.getOrDefault(configuration.getCategoryIdentifier(), quickCraftingEnabledByDefault);
                if (enabled) {
                    if (!quickCraftingEnabledByDefault) {
                        ConfigureCategoriesScreen.this.filteringQuickCraftCategories.remove(configuration.getCategoryIdentifier());
                    } else {
                        ConfigureCategoriesScreen.this.filteringQuickCraftCategories.put(configuration.getCategoryIdentifier(), false);
                    }
                } else if (quickCraftingEnabledByDefault) {
                    ConfigureCategoriesScreen.this.filteringQuickCraftCategories.remove(configuration.getCategoryIdentifier());
                } else {
                    ConfigureCategoriesScreen.this.filteringQuickCraftCategories.put(configuration.getCategoryIdentifier(), true);
                }
                ConfigureCategoriesScreen.this.editedSink.run();
            }).leftAligned();
            this.upButton = new Button.Plain(this, 0, 0, 20, 20, (Component)Component.literal((String)"\u2191"), button -> {
                int index = ConfigureCategoriesScreen.this.categoryOrdering.indexOf(configuration.getCategoryIdentifier());
                if (index > 0) {
                    ConfigureCategoriesScreen.this.categoryOrdering.remove(index);
                    ConfigureCategoriesScreen.this.categoryOrdering.add(index - 1, configuration.getCategoryIdentifier());
                    ConfigureCategoriesScreen.this.editedSink.run();
                    ConfigureCategoriesScreen.this.resetListEntries();
                }
            }, Supplier::get){};
            this.downButton = new Button.Plain(this, 0, 0, 20, 20, (Component)Component.literal((String)"\u2193"), button -> {
                int index = ConfigureCategoriesScreen.this.categoryOrdering.indexOf(configuration.getCategoryIdentifier());
                if (index < ConfigureCategoriesScreen.this.categoryOrdering.size() - 1) {
                    ConfigureCategoriesScreen.this.categoryOrdering.remove(index);
                    ConfigureCategoriesScreen.this.categoryOrdering.add(index + 1, configuration.getCategoryIdentifier());
                    ConfigureCategoriesScreen.this.editedSink.run();
                    ConfigureCategoriesScreen.this.resetListEntries();
                }
            }, Supplier::get){};
            this.upButton.active = ConfigureCategoriesScreen.this.categoryOrdering.indexOf(configuration.getCategoryIdentifier()) > 0;
            this.downButton.active = ConfigureCategoriesScreen.this.categoryOrdering.indexOf(configuration.getCategoryIdentifier()) < ConfigureCategoriesScreen.this.categoryOrdering.size() - 1;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            if (y + entryHeight < 0 || y > ConfigureCategoriesScreen.this.height) {
                return;
            }
            Minecraft client = Minecraft.getInstance();
            this.configuration.getCategory().getIcon().render(graphics, new Rectangle(x + 2, y, 16, 16), mouseY, mouseY, delta);
            int xPos = x + 22;
            Component title = this.configuration.getCategory().getTitle();
            int i = client.font.width((FormattedText)title);
            if (i > entryWidth - 28) {
                FormattedText titleTrimmed = FormattedText.composite((FormattedText[])new FormattedText[]{client.font.substrByWidth((FormattedText)title, entryWidth - 28 - client.font.width("...")), FormattedText.of((String)"...")});
                graphics.drawString(client.font, Language.getInstance().getVisualOrder(titleTrimmed), x + 2, y + 1, -1);
            } else {
                graphics.drawString(client.font, title.getVisualOrderText(), xPos, y + 1, -1);
            }
            MutableComponent id = Component.literal((String)this.configuration.getCategoryIdentifier().toString()).withStyle(ChatFormatting.DARK_GRAY);
            i = client.font.width((FormattedText)id);
            if (i > entryWidth - 28) {
                FormattedText idTrimmed = FormattedText.composite((FormattedText[])new FormattedText[]{client.font.substrByWidth((FormattedText)id, entryWidth - 28 - client.font.width("...")), FormattedText.of((String)"...")});
                graphics.drawString(client.font, Language.getInstance().getVisualOrder(idTrimmed), x + 2, y + 12, -8355712);
            } else {
                graphics.drawString(client.font, id.getVisualOrderText(), xPos, y + 12, -8355712);
            }
            boolean shown = !ConfigureCategoriesScreen.this.hiddenCategories.contains(this.configuration.getCategoryIdentifier());
            MutableComponent subtitle = Component.translatable((String)("config.roughlyenoughitems.configureCategories.visibility." + shown)).withStyle(shown ? ChatFormatting.GREEN : ChatFormatting.RED);
            graphics.drawString(client.font, (Component)subtitle, xPos, y + 22, -8355712);
            int i2 = xPos + client.font.width((FormattedText)subtitle);
            this.visibilityToggleButton.getPoint().setLocation((double)(i2 + 3), (double)(y + 22));
            this.visibilityToggleButton.render(graphics, mouseX, mouseY, delta);
            if (shown) {
                subtitle = Component.translatable((String)("config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure." + String.valueOf(ConfigureCategoriesScreen.this.filteringQuickCraftCategories.getOrDefault(this.configuration.getCategoryIdentifier(), this.configuration.isQuickCraftingEnabledByDefault())))).withStyle(ChatFormatting.GRAY);
                graphics.drawString(client.font, (Component)subtitle, xPos, y + 32, -8355712);
                i2 = xPos + client.font.width((FormattedText)subtitle);
                this.quickCraftToggleButton.getPoint().setLocation((double)(i2 + 3), (double)(y + 32));
                this.quickCraftToggleButton.render(graphics, mouseX, mouseY, delta);
            } else {
                this.quickCraftToggleButton.getPoint().setLocation(-12390.0, -12390.0);
            }
            this.upButton.setX(x + entryWidth - 20);
            this.upButton.setY(y + entryHeight / 2 - 21);
            this.upButton.render(graphics, mouseX, mouseY, delta);
            this.downButton.setX(x + entryWidth - 20);
            this.downButton.setY(y + entryHeight / 2 + 1);
            this.downButton.render(graphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return List.of(this.visibilityToggleButton, this.quickCraftToggleButton, this.upButton, this.downButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }
    }

    private static abstract class ListEntry
    extends UpdatedListWidget.ElementEntry<ListEntry> {
        private ListEntry() {
        }

        public int getItemHeight() {
            return 45;
        }
    }
}

