/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.Locale;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonElement;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonNull;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonObject;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.DeserializationException;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.addon.ConfigAddonRegistry;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.CheatingMode;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.config.FavoritesConfigManager;
import me.shedaniel.rei.impl.client.config.addon.ConfigAddonRegistryImpl;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.config.entries.ConfigAddonsEntry;
import me.shedaniel.rei.impl.client.gui.config.REIConfigScreen;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.IdentifierException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.InteractionResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ConfigManagerImpl
implements ConfigManager {
    private static final TagParser<Tag> NBT_OPS_PARSER = TagParser.create((DynamicOps)NbtOps.INSTANCE);
    private boolean craftableOnly = false;
    private final Gson gson = new GsonBuilder().create();
    private ConfigObjectImpl object;

    public ConfigManagerImpl() {
        AutoConfig.register(ConfigObjectImpl.class, (definition, configClass) -> new JanksonConfigSerializer(definition, configClass, ConfigManagerImpl.buildJankson(Jankson.builder())));
        InternalLogger.getInstance().info("Config loaded");
        this.saveConfig();
        FavoritesConfigManager.getInstance().syncFrom(this);
        CollapsibleConfigManager.getInstance().syncFrom(this);
    }

    public static Jankson buildJankson(Jankson.Builder builder) {
        builder.registerSerializer(Identifier.class, (location, marshaller) -> new JsonPrimitive((Object)(location == null ? null : location.toString())));
        builder.registerDeserializer(String.class, Identifier.class, (value, marshaller) -> value == null ? null : Identifier.parse((String)value));
        builder.registerSerializer(CheatingMode.class, (value, marshaller) -> {
            if (value == CheatingMode.WHEN_CREATIVE) {
                return new JsonPrimitive((Object)"WHEN_CREATIVE");
            }
            return new JsonPrimitive((Object)(value == CheatingMode.ON ? 1 : 0));
        });
        builder.registerDeserializer(Boolean.class, CheatingMode.class, (value, unmarshaller) -> value != false ? CheatingMode.ON : CheatingMode.OFF);
        builder.registerDeserializer(String.class, CheatingMode.class, (value, unmarshaller) -> CheatingMode.valueOf(value.toUpperCase(Locale.ROOT)));
        builder.registerSerializer(InputConstants.Key.class, (value, marshaller) -> new JsonPrimitive((Object)value.getName()));
        builder.registerDeserializer(String.class, InputConstants.Key.class, (value, marshaller) -> InputConstants.getKey((String)value));
        builder.registerSerializer(ModifierKeyCode.class, (value, marshaller) -> {
            JsonObject object = new JsonObject();
            object.put("keyCode", (JsonElement)new JsonPrimitive((Object)value.getKeyCode().getName()));
            object.put("modifier", (JsonElement)new JsonPrimitive((Object)value.getModifier().getValue()));
            return object;
        });
        builder.registerDeserializer(JsonObject.class, ModifierKeyCode.class, (value, marshaller) -> {
            String code = (String)value.get(String.class, "keyCode");
            if (code.endsWith(".unknown")) {
                return ModifierKeyCode.unknown();
            }
            InputConstants.Key keyCode = InputConstants.getKey((String)code);
            Modifier modifier = Modifier.of((short)value.getShort("modifier", (short)0));
            return ModifierKeyCode.of((InputConstants.Key)keyCode, (Modifier)modifier);
        });
        builder.registerSerializer(Tag.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, Tag.class, (value, marshaller) -> {
            try {
                return (Tag)NBT_OPS_PARSER.parseFully(value);
            }
            catch (CommandSyntaxException e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        builder.registerSerializer(CompoundTag.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, CompoundTag.class, (value, marshaller) -> {
            try {
                return TagParser.parseCompoundFully((String)value);
            }
            catch (CommandSyntaxException e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        builder.registerSerializer(EntryStackProvider.class, (stack, marshaller) -> {
            try {
                return marshaller.serialize((Object)stack.save());
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(Tag.class, EntryStackProvider.class, (value, marshaller) -> EntryStackProvider.defer(value));
        builder.registerDeserializer(String.class, EntryStackProvider.class, (value, marshaller) -> {
            try {
                return EntryStackProvider.defer((Tag)NBT_OPS_PARSER.parseFully(new StringReader(value)));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return EntryStackProvider.ofStack(EntryStack.empty());
            }
        });
        builder.registerSerializer(FilteringRule.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)FilteringRuleType.save(value, new CompoundTag()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(Tag.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRuleType.read((CompoundTag)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerDeserializer(String.class, FilteringRule.class, (value, marshaller) -> {
            try {
                return FilteringRuleType.read(TagParser.parseCompoundFully((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerSerializer(FavoriteEntry.class, (value, marshaller) -> {
            try {
                return marshaller.serialize((Object)value.save(new CompoundTag()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return JsonNull.INSTANCE;
            }
        });
        builder.registerDeserializer(Tag.class, FavoriteEntry.class, (value, marshaller) -> FavoriteEntry.readDelegated((CompoundTag)value));
        builder.registerDeserializer(String.class, FavoriteEntry.class, (value, marshaller) -> {
            try {
                CompoundTag tag = TagParser.parseCompoundFully((String)value);
                return FavoriteEntry.readDelegated(tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        builder.registerSerializer(CategoryIdentifier.class, (value, marshaller) -> marshaller.serialize((Object)value.toString()));
        builder.registerDeserializer(String.class, CategoryIdentifier.class, (value, marshaller) -> {
            try {
                return CategoryIdentifier.of(value);
            }
            catch (IdentifierException e) {
                throw new DeserializationException((Throwable)e);
            }
        });
        return builder.build();
    }

    @Override
    public void startReload() {
    }

    public static ConfigManagerImpl getInstance() {
        return (ConfigManagerImpl)ConfigManager.getInstance();
    }

    @Override
    public void saveConfig() {
        for (FilteringRuleType type : FilteringRuleTypeRegistry.getInstance()) {
            if (!type.isSingular() || !this.getConfig().getFilteringRules().stream().noneMatch(filteringRule -> filteringRule.getType().equals(type))) continue;
            this.getConfig().getFilteringRules().add((FilteringRule<?>)type.createNew());
        }
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).registerLoadListener((configHolder, configObject) -> {
            this.object = configObject;
            return InteractionResult.PASS;
        });
        AutoConfig.getConfigHolder(ConfigObjectImpl.class).save();
        FavoritesConfigManager.getInstance().saveConfig();
        InternalLogger.getInstance().debug("Config saved");
    }

    @Override
    public ConfigObjectImpl getConfig() {
        if (this.object == null) {
            this.object = (ConfigObjectImpl)AutoConfig.getConfigHolder(ConfigObjectImpl.class).getConfig();
        }
        return this.object;
    }

    @Override
    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly && this.getConfig().isCraftableFilterEnabled();
    }

    @Override
    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    @Override
    public Screen getConfigScreen(Screen parent) {
        return new REIConfigScreen(parent);
    }

    private static /* synthetic */ Screen lambda$getConfigScreen$27(ConfigBuilder builder) {
        ConfigAddonRegistryImpl addonRegistry = (ConfigAddonRegistryImpl)ConfigAddonRegistry.getInstance();
        if (!addonRegistry.getAddons().isEmpty()) {
            builder.getOrCreateCategory((Component)Component.translatable((String)"config.roughlyenoughitems.basics")).getEntries().add(0, new ConfigAddonsEntry(220));
        }
        return null;
    }
}

