/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemRecipeFinder {
    private final Interner<ItemKey> keys = Interners.newWeakInterner();
    private final RecipeFinder<ItemKey, Ingredient> finder = new RecipeFinder();

    public boolean contains(ItemStack item) {
        return this.finder.contains(this.ofKey(item));
    }

    boolean containsAtLeast(ItemStack object, int i) {
        return this.finder.containsAtLeast(this.ofKey(object), i);
    }

    public void take(ItemStack item, int amount) {
        this.finder.take(this.ofKey(item), amount);
    }

    public void put(ItemStack item, int amount) {
        this.finder.put(this.ofKey(item), amount);
    }

    public void addNormalItem(ItemStack itemStack) {
        if (Inventory.isUsableForCrafting((ItemStack)itemStack)) {
            this.addItem(itemStack);
        }
    }

    public void addItem(ItemStack itemStack) {
        this.addItem(itemStack, itemStack.getMaxStackSize());
    }

    public void addItem(ItemStack itemStack, int i) {
        if (!itemStack.isEmpty()) {
            int j = Math.min(i, itemStack.getCount());
            this.finder.put(this.ofKey(itemStack), j);
        }
    }

    public boolean findRecipe(List<List<ItemStack>> list, int maxCrafts, @Nullable Consumer<ItemStack> output) {
        return this.finder.findRecipe(this.toIngredients(list), maxCrafts, ItemRecipeFinder.flatten(itemStack -> {
            if (output != null) {
                output.accept((ItemStack)itemStack);
            }
        }));
    }

    public int countRecipeCrafts(List<List<ItemStack>> list, int maxCrafts, @Nullable Consumer<ItemStack> output) {
        return this.finder.countRecipeCrafts(this.toIngredients(list), maxCrafts, ItemRecipeFinder.flatten(itemStack -> {
            if (output != null) {
                output.accept((ItemStack)itemStack);
            }
        }));
    }

    private ItemKey ofKey(ItemStack itemStack) {
        return (ItemKey)this.keys.intern((Object)new ItemKey((Holder<Item>)itemStack.getItemHolder(), itemStack.getComponentsPatch()));
    }

    private Ingredient ofKeys(int index, List<ItemStack> itemStack) {
        return new Ingredient(index, CollectionUtils.map(itemStack, this::ofKey));
    }

    private List<Ingredient> toIngredients(List<List<ItemStack>> list) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (int i = 0; i < list.size(); ++i) {
            List<ItemStack> stacks = list.get(i);
            if (stacks.isEmpty()) continue;
            ingredients.add(this.ofKeys(i, stacks));
        }
        return ingredients;
    }

    private static BiConsumer<ItemKey, Ingredient> flatten(Consumer<ItemStack> consumer) {
        int[] lastIndex = new int[]{-1};
        return (itemKey, ingredient) -> {
            for (int i = lastIndex[0] + 1; i < ingredient.index(); ++i) {
                consumer.accept(ItemStack.EMPTY);
            }
            consumer.accept(new ItemStack(itemKey.item(), 1, itemKey.patch()));
            lastIndex[0] = ingredient.index();
        };
    }

    private record ItemKey(Holder<Item> item, DataComponentPatch patch) {
    }

    private record Ingredient(int index, List<ItemKey> elements) implements RecipeFinder.Ingredient<ItemKey>
    {
    }
}

