/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class ItemRecipeFinder {
    private final Interner<ItemKey> keys = Interners.newWeakInterner();
    private final RecipeFinder<ItemKey, Ingredient> finder = new RecipeFinder();

    public boolean contains(class_1799 item) {
        return this.finder.contains(this.ofKey(item));
    }

    boolean containsAtLeast(class_1799 object, int i) {
        return this.finder.containsAtLeast(this.ofKey(object), i);
    }

    public void take(class_1799 item, int amount) {
        this.finder.take(this.ofKey(item), amount);
    }

    public void put(class_1799 item, int amount) {
        this.finder.put(this.ofKey(item), amount);
    }

    public void addNormalItem(class_1799 itemStack) {
        if (class_1661.method_61495((class_1799)itemStack)) {
            this.addItem(itemStack);
        }
    }

    public void addItem(class_1799 itemStack) {
        this.addItem(itemStack, itemStack.method_7914());
    }

    public void addItem(class_1799 itemStack, int i) {
        if (!itemStack.method_7960()) {
            int j = Math.min(i, itemStack.method_7947());
            this.finder.put(this.ofKey(itemStack), j);
        }
    }

    public boolean findRecipe(List<List<class_1799>> list, int maxCrafts, @Nullable Consumer<class_1799> output) {
        return this.finder.findRecipe(this.toIngredients(list), maxCrafts, ItemRecipeFinder.flatten(itemStack -> {
            if (output != null) {
                output.accept((class_1799)itemStack);
            }
        }));
    }

    public int countRecipeCrafts(List<List<class_1799>> list, int maxCrafts, @Nullable Consumer<class_1799> output) {
        return this.finder.countRecipeCrafts(this.toIngredients(list), maxCrafts, ItemRecipeFinder.flatten(itemStack -> {
            if (output != null) {
                output.accept((class_1799)itemStack);
            }
        }));
    }

    private ItemKey ofKey(class_1799 itemStack) {
        return (ItemKey)this.keys.intern((Object)new ItemKey((class_6880<class_1792>)itemStack.method_41409(), itemStack.method_57380()));
    }

    private Ingredient ofKeys(int index, List<class_1799> itemStack) {
        return new Ingredient(index, CollectionUtils.map(itemStack, this::ofKey));
    }

    private List<Ingredient> toIngredients(List<List<class_1799>> list) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (int i = 0; i < list.size(); ++i) {
            List<class_1799> stacks = list.get(i);
            if (stacks.isEmpty()) continue;
            ingredients.add(this.ofKeys(i, stacks));
        }
        return ingredients;
    }

    private static BiConsumer<ItemKey, Ingredient> flatten(Consumer<class_1799> consumer) {
        int[] lastIndex = new int[]{-1};
        return (itemKey, ingredient) -> {
            for (int i = lastIndex[0] + 1; i < ingredient.index(); ++i) {
                consumer.accept(class_1799.field_8037);
            }
            consumer.accept(new class_1799(itemKey.item(), 1, itemKey.patch()));
            lastIndex[0] = ingredient.index();
        };
    }

    private record ItemKey(class_6880<class_1792> item, class_9326 patch) {
    }

    private record Ingredient(int index, List<ItemKey> elements) implements RecipeFinder.Ingredient<ItemKey>
    {
    }
}

