/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1876;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import java.util.*;

public class TippedArrowRecipeFiller implements CraftingRecipeFiller<class_1876> {
    @Override
    public Collection<Display> apply(class_8786<class_1876> recipe) {
        EntryIngredient arrowStack = EntryIngredient.of(EntryStacks.of(class_1802.field_8107));
        Set<class_2960> registeredPotions = new HashSet<>();
        List<Display> displays = new ArrayList<>();
        
        class_5455 registryAccess = BasicDisplay.registryAccess();
        BasicDisplay.registryAccess().method_46759(class_7924.field_41215).stream()
                .flatMap(class_2378::method_42017)
                .map(reference -> class_1844.method_57400(class_1802.field_8150, reference))
                .forEach(itemStack -> {
                    class_1844 potion = itemStack.method_58694(class_9334.field_49651);
                    if (potion.comp_2378().isPresent() && potion.comp_2378().get().method_40230().isPresent() && registeredPotions.add(potion.comp_2378().get().method_40230().get().method_29177())) {
                        List<EntryIngredient> input = new ArrayList<>();
                        for (int i = 0; i < 4; i++)
                            input.add(arrowStack);
                        input.add(EntryIngredients.of(itemStack));
                        for (int i = 0; i < 4; i++)
                            input.add(arrowStack);
                        class_1799 outputStack = new class_1799(class_1802.field_8087, 8);
                        outputStack.method_57379(class_9334.field_49651, potion);
                        displays.add(new DefaultCustomDisplay(input, List.of(EntryIngredients.of(outputStack)), Optional.of(recipe.comp_1932().method_29177())));
                    }
                });
        
        return displays;
    }
    
    @Override
    public Class<class_1876> getRecipeClass() {
        return class_1876.class;
    }
}
