/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Environment(EnvType.CLIENT)
public class DefaultInformationCategory implements DisplayCategory<DefaultInformationDisplay> {
    @Override
    public CategoryIdentifier<? extends DefaultInformationDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.INFO;
    }
    
    @Override
    public class_2561 getTitle() {
        return class_2561.method_43471("category.rei.information");
    }
    
    @Override
    public DisplayRenderer getDisplayRenderer(DefaultInformationDisplay display) {
        class_5481 name = display.getName().method_30937();
        return new DisplayRenderer() {
            @Override
            public int getHeight() {
                return 10 + class_310.method_1551().field_1772.field_2000;
            }
            
            @Override
            public void render(class_332 graphics, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                graphics.method_51430(class_310.method_1551().field_1772, name, rectangle.x + 5, rectangle.y + 6, -1, false);
            }
        };
    }
    
    @Override
    public Renderer getIcon() {
        return new Renderer() {
            @Override
            public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate(-1.2f, -1);
                graphics.method_25295(class_10799.field_56883, REIRuntime.getInstance().getDefaultDisplayTexture(), bounds.getCenterX() - 8, bounds.getCenterX() + 8, bounds.getCenterY() - 8, bounds.getCenterY() + 8, 116f / 256f, (116f + 16f) / 256f, 0f, 16f / 256f, -1);
                graphics.method_51448().popMatrix();
            }
        };
    }
    
    @Override
    public List<Widget> setupDisplay(DefaultInformationDisplay display, Rectangle bounds) {
        List<Widget> widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createSlot(new Point(bounds.getCenterX() - 8, bounds.y + 15 - 9)).entries(display.getEntryStacks()));
        Rectangle rectangle = new Rectangle(bounds.getCenterX() - (bounds.width * 0.95 / 2), bounds.y + 35 - 9, bounds.width * 0.95, bounds.height - 40 + 9);
        widgets.add(new ScrollableTextWidget(rectangle, display.getTexts()));
        return widgets;
    }
    
    @Override
    public int getDisplayHeight() {
        return 140;
    }
    
    @Override
    public int getFixedDisplaysPerPage() {
        return 1;
    }
    
    private static class ScrollableTextWidget extends WidgetWithBounds {
        private Rectangle bounds;
        private List<class_5481> texts;
        private final ScrollingContainer scrolling = new ScrollingContainer() {
            @Override
            public Rectangle getBounds() {
                Rectangle bounds = ScrollableTextWidget.this.getBounds();
                return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            }
            
            @Override
            public int getMaxScrollHeight() {
                int i = 2;
                for (class_5481 entry : texts) {
                    i += entry == null ? 4 : font.field_2000;
                }
                return i;
            }
        };
        
        public ScrollableTextWidget(Rectangle bounds, List<class_2561> texts) {
            this.bounds = Objects.requireNonNull(bounds);
            this.texts = Lists.newArrayList();
            for (class_5348 text : texts) {
                if (!this.texts.isEmpty())
                    this.texts.add(null);
                this.texts.addAll(class_310.method_1551().field_1772.method_1728(text, bounds.width - 11));
            }
        }
        
        @Override
        public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
            if (containsMouse(mouseX, mouseY) && amountY != 0) {
                scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
                return true;
            }
            return false;
        }
        
        @Override
        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (scrolling.updateDraggingState(event.comp_4798(), event.comp_4799(), event.method_74245()))
                return true;
            return super.method_25402(event, doubleClick);
        }
        
        @Override
        public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
            if (scrolling.mouseDragged(event.comp_4798(), event.comp_4799(), event.method_74245(), deltaX, deltaY))
                return true;
            return super.method_25403(event, deltaX, deltaY);
        }
        
        @Override
        public Rectangle getBounds() {
            return bounds;
        }
        
        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            scrolling.updatePosition(delta);
            Rectangle innerBounds = scrolling.getScissorBounds();
            try (CloseableScissors scissors = scissor(graphics, innerBounds)) {
                int currentY = -scrolling.scrollAmountInt() + innerBounds.y;
                for (class_5481 text : texts) {
                    if (text != null && currentY + font.field_2000 >= innerBounds.y && currentY <= innerBounds.getMaxY()) {
                        graphics.method_51430(font, text, innerBounds.x + 2, currentY + 2, REIRuntime.getInstance().isDarkThemeEnabled() ? 0xFFBBBBBB : 0xFF090909, false);
                    }
                    currentY += text == null ? 4 : font.field_2000;
                }
            }
            if (scrolling.hasScrollBar()) {
                if (scrolling.scrollAmount() > 8) {
                    graphics.method_25296(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.y + 16, 0xFFC6C6C6, 0x00C6C6C6);
                }
                if (scrolling.getMaxScroll() - scrolling.scrollAmount() > 8) {
                    graphics.method_25296(innerBounds.x, innerBounds.getMaxY() - 16, innerBounds.getMaxX(), innerBounds.getMaxY(), 0x00C6C6C6, 0xFFC6C6C6);
                }
            }
            try (CloseableScissors scissors = scissor(graphics, scrolling.getBounds())) {
                scrolling.renderScrollBar(graphics, 0, 1f);
            }
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }
}
