/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.transfer;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.ItemRecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.class_10260;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_465;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import java.util.ArrayList;
import java.util.List;

public enum SimpleTransferHandlerImpl implements ClientInternals.SimpleTransferHandler {
    INSTANCE;
    
    @Override
    public TransferHandler.Result handle(TransferHandler.Context context, SimpleTransferHandler.MissingInputRenderer missingInputRenderer, List<InputIngredient<class_1799>> inputs, Iterable<SlotAccessor> inputSlots, Iterable<SlotAccessor> inventorySlots) {
        class_465<?> containerScreen = context.getContainerScreen();
        List<InputIngredient<class_1799>> missing = SimpleTransferHandlerImpl.hasItemsIndexed(context, inventorySlots, inputs);
        
        if (!missing.isEmpty()) {
            IntSet missingIndices = new IntLinkedOpenHashSet(missing.size());
            for (InputIngredient<class_1799> ingredient : missing) {
                missingIndices.add(ingredient.getDisplayIndex());
            }
            return TransferHandler.Result.createFailed(class_2561.method_43471("error.rei.not.enough.materials"))
                    .renderer((matrices, mouseX, mouseY, delta, widgets, bounds, d) -> {
                        missingInputRenderer.renderMissingInput(context, inputs, missing, missingIndices, matrices, mouseX, mouseY, delta, widgets, bounds);
                    })
                    .tooltipMissing(CollectionUtils.map(missing, ingredient -> EntryIngredients.ofItemStacks(ingredient.get())));
        }
        
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed(class_2561.method_43471("error.rei.not.on.server"));
        }
        
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        
        context.getMinecraft().method_1507(containerScreen);
        if (containerScreen instanceof class_10260<?> screen) {
            screen.field_54474.field_52843.method_62029();
        }
        
        class_9129 buf = new class_9129(Unpooled.buffer(), context.getMinecraft().method_1562().method_29091());
        buf.method_10812(context.getDisplay().getCategoryIdentifier().getIdentifier());
        buf.method_52964(context.isStackedCrafting());
        
        buf.method_10794(save(context, buf.method_56349(), inputs, inputSlots, inventorySlots));
        NetworkManager.sendToServer(RoughlyEnoughItemsNetwork.MOVE_ITEMS_NEW_PACKET, buf);
        return TransferHandler.Result.createSuccessful();
    }
    
    private class_2487 save(TransferHandler.Context context, class_5455 access, List<InputIngredient<class_1799>> inputs, Iterable<SlotAccessor> inputSlots, Iterable<SlotAccessor> inventorySlots) {
        class_2487 tag = new class_2487();
        tag.method_10569("Version", 1);
        tag.method_10566("Inputs", saveInputs(access, inputs));
        tag.method_10566("InventorySlots", saveSlots(context, inventorySlots));
        tag.method_10566("InputSlots", saveSlots(context, inputSlots));
        return tag;
    }
    
    private class_2520 saveSlots(TransferHandler.Context context, Iterable<SlotAccessor> slots) {
        class_2499 tag = new class_2499();
        
        for (SlotAccessor slot : slots) {
            tag.add(SlotAccessorRegistry.getInstance().save(context.getMenu(), context.getMinecraft().field_1724, slot));
        }
        
        return tag;
    }
    
    private class_2520 saveInputs(class_5455 access, List<InputIngredient<class_1799>> inputs) {
        class_2499 tag = new class_2499();
        
        for (InputIngredient<class_1799> input : inputs) {
            class_2487 innerTag = new class_2487();
            class_2520 ingredientTag = EntryIngredient.codec().encodeStart(access.method_57093(class_2509.field_11560), EntryIngredients.ofItemStacks(input.get())).getOrThrow();
            innerTag.method_10566("Ingredient", ingredientTag);
            innerTag.method_10569("Index", input.getIndex());
            tag.add(innerTag);
        }
        
        return tag;
    }
    
    public static List<InputIngredient<class_1799>> hasItemsIndexed(TransferHandler.Context context, Iterable<SlotAccessor> inventorySlots, List<InputIngredient<class_1799>> inputs) {
        // Create a clone of player's inventory, and count
        ItemRecipeFinder recipeFinder = new ItemRecipeFinder();
        for (SlotAccessor slot : inventorySlots) {
            recipeFinder.addNormalItem(slot.getItemStack());
        }
        List<InputIngredient<class_1799>> missing = new ArrayList<>();
        for (InputIngredient<class_1799> possibleStacks : inputs) {
            boolean done = possibleStacks.get().isEmpty();
            for (class_1799 possibleStack : possibleStacks.get()) {
                if (!done) {
                    int invRequiredCount = possibleStack.method_7947();
                    while (invRequiredCount > 0 && recipeFinder.contains(possibleStack)) {
                        invRequiredCount--;
                        recipeFinder.take(possibleStack, 1);
                    }
                    if (invRequiredCount <= 0) {
                        done = true;
                        break;
                    }
                }
            }
            if (!done) {
                missing.add(possibleStacks);
            }
        }
        return missing;
    }
}
