/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.tag;

import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import me.shedaniel.rei.api.common.util.UUIDUtils;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TagNodes {
    public static final class_2960 REQUEST_TAGS_C2S_PACKET_ID = class_2960.method_60655((String)"roughlyenoughitems", (String)"request_tags_c2s");
    public static final class_2960 REQUEST_TAGS_S2C_PACKET_ID = class_2960.method_60655((String)"roughlyenoughitems", (String)"request_tags_s2c");
    public static final class_8710.class_9154<C2STagDataPacket> REQUEST_TAGS_C2S_PACKET_TYPE = new class_8710.class_9154(REQUEST_TAGS_C2S_PACKET_ID);
    public static final class_8710.class_9154<S2CTagDataPacket> REQUEST_TAGS_S2C_PACKET_TYPE = new class_8710.class_9154(REQUEST_TAGS_S2C_PACKET_ID);
    public static final Map<String, class_5321<? extends class_2378<?>>> TAG_DIR_MAP = new HashMap();
    public static final ThreadLocal<String> CURRENT_TAG_DIR = new ThreadLocal();
    public static final Map<String, Map<CollectionWrapper<?>, RawTagData>> RAW_TAG_DATA_MAP = new ConcurrentHashMap();
    public static final Map<class_5321<? extends class_2378<?>>, Map<class_2960, TagData>> TAG_DATA_MAP = new HashMap();
    public static Map<class_5321<? extends class_2378<?>>, Consumer<Consumer<DataResult<Map<class_2960, TagData>>>>> requestedTags = new HashMap();

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::init);
        EnvExecutor.runInEnv((Env)Env.SERVER, () -> Server::init);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), REQUEST_TAGS_C2S_PACKET_TYPE, C2STagDataPacket.STREAM_CODEC, (payload, context) -> {
            class_5321 registryKey = class_5321.method_29180((class_2960)payload.registryName);
            Map<class_2960, TagData> dataMap = TAG_DATA_MAP.getOrDefault(registryKey, Collections.emptyMap());
            S2CTagDataPacket packet = new S2CTagDataPacket(payload.uuid, dataMap);
            NetworkManager.sendToPlayer((class_3222)((class_3222)context.getPlayer()), (class_8710)packet);
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void requestTagData(class_5321<? extends class_2378<?>> resourceKey, Consumer<DataResult<Map<class_2960, TagData>>> callback) {
        if (class_310.method_1551().method_1576() != null) {
            callback.accept((DataResult<Map<class_2960, TagData>>)DataResult.success(TAG_DATA_MAP.get(resourceKey)));
        } else if (!NetworkManager.canServerReceive((class_2960)REQUEST_TAGS_C2S_PACKET_ID)) {
            callback.accept((DataResult<Map<class_2960, TagData>>)DataResult.error(() -> "Cannot request tags from server"));
        } else if (requestedTags.containsKey(resourceKey)) {
            requestedTags.get(resourceKey).accept(callback);
            callback.accept((DataResult<Map<class_2960, TagData>>)DataResult.success(TAG_DATA_MAP.getOrDefault(resourceKey, Collections.emptyMap())));
        } else {
            UUID uuid = UUID.randomUUID();
            C2STagDataPacket packet = new C2STagDataPacket(uuid, resourceKey.method_29177());
            Client.nextUUID = uuid;
            Client.nextResourceKey = resourceKey;
            CopyOnWriteArrayList<Consumer<DataResult<Map<class_2960, TagData>>>> callbacks = new CopyOnWriteArrayList<Consumer<DataResult<Map<class_2960, TagData>>>>();
            callbacks.add(callback);
            Client.nextCallback = mapDataResult -> {
                requestedTags.put(resourceKey, c -> c.accept(mapDataResult));
                for (Consumer consumer : callbacks) {
                    consumer.accept(mapDataResult);
                }
            };
            requestedTags.put(resourceKey, callbacks::add);
            NetworkManager.sendToServer((class_8710)packet);
        }
    }

    public static <T> void create(class_6862<T> tagKey, Consumer<DataResult<TagNode<T>>> callback) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_31140(tagKey.comp_326());
        TagNodes.requestTagData(tagKey.comp_326(), result -> callback.accept(result.flatMap(dataMap -> dataMap != null ? TagNodes.resolveTag(tagKey, registry, dataMap).orElse(DataResult.error(() -> "No tag data")) : DataResult.error(() -> "No tag data"))));
    }

    private static <T> Optional<DataResult<TagNode<T>>> resolveTag(class_6862<T> tagKey, class_2378<T> registry, Map<class_2960, TagData> tagDataMap) {
        TagData tagData = tagDataMap.get(tagKey.comp_327());
        if (tagData == null) {
            return Optional.empty();
        }
        TagNode<T> self = TagNode.ofReference(tagKey);
        ArrayList<class_6880> holders = new ArrayList<class_6880>();
        IntListIterator intListIterator = tagData.otherElements().iterator();
        while (intListIterator.hasNext()) {
            int element = (Integer)intListIterator.next();
            Optional holder = registry.method_40265(element);
            if (!holder.isPresent()) continue;
            holders.add((class_6880)holder.get());
        }
        if (!holders.isEmpty()) {
            self.addValuesChild((class_6885<T>)class_6885.method_40242(holders));
        }
        for (class_2960 childTagId : tagData.otherTags()) {
            Optional<DataResult<TagNode<T>>> resultOptional;
            class_6862 childTagKey = class_6862.method_40092((class_5321)tagKey.comp_326(), (class_2960)childTagId);
            if (!registry.method_46733(childTagKey).isPresent() || !(resultOptional = TagNodes.resolveTag(childTagKey, registry, tagDataMap)).isPresent()) continue;
            DataResult result = resultOptional.get();
            if (result.error().isPresent()) {
                return Optional.of(DataResult.error(() -> ((DataResult.Error)result.error().get()).message()));
            }
            self.addChild((TagNode)result.result().get());
        }
        return Optional.of(DataResult.success(self));
    }

    public record C2STagDataPacket(UUID uuid, class_2960 registryName) implements class_8710
    {
        public static final class_9139<class_9129, C2STagDataPacket> STREAM_CODEC = class_9139.method_56435(UUIDUtils.STREAM_CODEC, C2STagDataPacket::uuid, (class_9139)class_2960.field_48267, C2STagDataPacket::registryName, C2STagDataPacket::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return REQUEST_TAGS_C2S_PACKET_TYPE;
        }
    }

    private static class Client {
        public static UUID nextUUID;
        public static class_5321<? extends class_2378<?>> nextResourceKey;
        public static Consumer<DataResult<Map<class_2960, TagData>>> nextCallback;

        private Client() {
        }

        private static void init() {
            ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(world -> requestedTags.clear());
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), REQUEST_TAGS_S2C_PACKET_TYPE, S2CTagDataPacket.STREAM_CODEC, (payload, context) -> {
                if (!nextUUID.equals(payload.uuid)) {
                    return;
                }
                TAG_DATA_MAP.put(nextResourceKey, payload.map);
                nextCallback.accept((DataResult<Map<class_2960, TagData>>)DataResult.success(payload.map));
                nextUUID = null;
                nextResourceKey = null;
                nextCallback = null;
            });
        }
    }

    public record TagData(IntList otherElements, List<class_2960> otherTags) {
        public static final class_9139<class_9129, TagData> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56376(IntArrayList::new, (class_9139)class_9135.field_48550), TagData::otherElements, (class_9139)class_9135.method_56376(ArrayList::new, (class_9139)class_2960.field_48267), TagData::otherTags, TagData::new);
    }

    public record S2CTagDataPacket(UUID uuid, Map<class_2960, TagData> map) implements class_8710
    {
        public static final class_9139<class_9129, S2CTagDataPacket> STREAM_CODEC = class_9139.method_56435(UUIDUtils.STREAM_CODEC, S2CTagDataPacket::uuid, (class_9139)class_9135.method_56377(Maps::newHashMapWithExpectedSize, (class_9139)class_2960.field_48267, TagData.STREAM_CODEC), S2CTagDataPacket::map, S2CTagDataPacket::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return REQUEST_TAGS_S2C_PACKET_TYPE;
        }
    }

    private static class Server {
        private Server() {
        }

        private static void init() {
            NetworkManager.registerS2CPayloadType(REQUEST_TAGS_S2C_PACKET_TYPE, S2CTagDataPacket.STREAM_CODEC);
        }
    }

    public record RawTagData(List<class_2960> otherElements, List<class_2960> otherTags) {
    }

    public static class CollectionWrapper<T> {
        private final Collection<T> collection;

        public CollectionWrapper(Collection<T> collection) {
            this.collection = collection;
        }

        public boolean equals(Object obj) {
            return obj instanceof CollectionWrapper && ((CollectionWrapper)obj).collection == this.collection;
        }

        public int hashCode() {
            return System.identityHashCode(this.collection);
        }
    }
}

