/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.gui.widgets.utils.PanelTextures;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class DisplayCompositeWidget
extends DelegateWidgetWithBounds
implements DraggableComponentProviderWidget<Object> {
    private final DisplaySpec display;
    private final List<Widget> widgets;

    public DisplayCompositeWidget(DisplaySpec display, List<Widget> widgets, Rectangle bounds) {
        super(Widgets.concat(widgets), () -> bounds);
        this.display = display;
        this.widgets = widgets;
    }

    @Override
    @Nullable
    public DraggableComponent<Object> getHovered(DraggingContext<class_437> context, double mouseX, double mouseY) {
        return StreamSupport.stream(Widgets.walk(this.widget.method_25396(), widget -> widget instanceof DraggableComponentProviderWidget).spliterator(), false).map(widget -> widget.getHovered(context, mouseX, mouseY)).filter(Objects::nonNull).findFirst().orElseGet(() -> {
            if (this.containsMouse(mouseX, mouseY)) {
                return new DisplayDraggableComponent(Widgets.concat(CollectionUtils.filterToList(this.widgets, w -> !(w instanceof Panel))), this.display.provideInternalDisplay(), this.getBounds(), this.getBounds());
            }
            return null;
        });
    }

    @Override
    public boolean method_25404(class_11908 event) {
        FavoriteEntry favoriteEntry;
        if (super.method_25404(event)) {
            return true;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(DisplayCompositeWidget.mouse()) && ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(event.comp_4795(), event.comp_4796()) && (favoriteEntry = (FavoriteEntry)FavoriteEntryType.registry().get(FavoriteEntryType.DISPLAY).fromArgs(this.display.provideInternalDisplay()).result().orElse(null)) != null) {
            ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25406(class_11909 event) {
        FavoriteEntry favoriteEntry;
        if (super.method_25406(event)) {
            return true;
        }
        if (ConfigObject.getInstance().isFavoritesEnabled() && this.containsMouse(event.comp_4798(), event.comp_4799()) && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(event.method_74245()) && (favoriteEntry = (FavoriteEntry)FavoriteEntryType.registry().get(FavoriteEntryType.DISPLAY).fromArgs(this.display.provideInternalDisplay()).result().orElse(null)) != null) {
            ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            return true;
        }
        return false;
    }

    public static class DisplayDraggableComponent
    implements DraggableComponent<Display> {
        private final Widget widget;
        private final Display display;
        private final Rectangle originBounds;
        private final Rectangle bounds;
        private final Panel panel;
        private final Slot slot;
        public boolean onFavoritesRegion;

        public DisplayDraggableComponent(Widget widget, Display display, Rectangle originBounds, Rectangle bounds) {
            this.widget = widget;
            this.display = display;
            this.originBounds = originBounds;
            this.bounds = bounds;
            this.panel = Widgets.createRecipeBase(bounds.clone());
            this.slot = Widgets.createSlot(new Rectangle()).disableBackground().disableHighlight().disableTooltips();
            for (EntryIngredient ingredient : display.getOutputEntries()) {
                this.slot.entries(ingredient);
            }
        }

        @Override
        public int getWidth() {
            if (this.onFavoritesRegion) {
                return 18;
            }
            return this.bounds.width / 2;
        }

        @Override
        public int getHeight() {
            if (this.onFavoritesRegion) {
                return 18;
            }
            return this.bounds.height / 2;
        }

        @Override
        public Display get() {
            return this.display;
        }

        @Override
        public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (DraggingContext.getInstance().isDraggingComponent()) {
                FavoritesListWidget favorites = ScreenOverlayImpl.getFavoritesListWidget();
                if (favorites != null) {
                    Rectangle favoritesBounds = favorites.getRegion().getBounds();
                    if (!this.onFavoritesRegion && new Rectangle(favoritesBounds.x + 5, favoritesBounds.y + 5, favoritesBounds.width - 10, favoritesBounds.height - 10).contains(DraggingContext.getInstance().getCurrentPosition())) {
                        this.onFavoritesRegion = true;
                    } else if (this.onFavoritesRegion && !favoritesBounds.contains(DraggingContext.getInstance().getCurrentPosition())) {
                        this.onFavoritesRegion = false;
                    }
                } else {
                    this.onFavoritesRegion = false;
                }
            } else {
                this.onFavoritesRegion = false;
            }
            graphics.method_51448().pushMatrix();
            if (bounds.width <= Math.max(18, this.bounds.width / 2 - 6) && bounds.height <= Math.max(18, this.bounds.height / 2 - 6) && this.onFavoritesRegion) {
                this.panel.texture(PanelTextures.LIGHTER);
                this.panel.getBounds().setBounds(bounds);
                this.panel.method_25394(graphics, mouseX, mouseY, delta);
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate(0.0f, 0.5f);
                this.slot.getBounds().setBounds(bounds.getCenterX() - 7, bounds.getCenterY() - 7, 14, 14);
                this.slot.method_25394(graphics, mouseX, mouseY, delta);
                graphics.method_51448().popMatrix();
            } else {
                this.panel.texture(ConfigObject.getInstance().getRecipeBorderType());
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate((float)bounds.getX(), (float)bounds.getY());
                graphics.method_51448().scale((float)bounds.width / (float)this.bounds.getWidth(), (float)bounds.height / (float)this.bounds.getHeight());
                graphics.method_51448().translate((float)(-this.bounds.getX()), (float)(-this.bounds.getY()));
                this.panel.getBounds().setBounds(this.bounds);
                this.panel.method_25394(graphics, mouseX, mouseY, delta);
                graphics.method_51448().popMatrix();
                graphics.method_51448().translate((float)bounds.getX(), (float)bounds.getY());
                graphics.method_51448().scale((float)bounds.width / (float)this.bounds.getWidth(), (float)bounds.height / (float)this.bounds.getHeight());
                graphics.method_51448().translate((float)(-this.bounds.getX()), (float)(-this.bounds.getY()));
                this.widget.method_25394(graphics, -1000, -1000, delta);
            }
            graphics.method_51448().popMatrix();
        }

        @Override
        public void release(DraggedAcceptorResult result) {
            if (result == DraggedAcceptorResult.PASS) {
                DraggingContext.getInstance().renderBack(this, DraggingContext.getInstance().getCurrentBounds(), () -> this.originBounds);
            }
        }

        @Override
        public Rectangle getOriginBounds(Point mouse) {
            return this.originBounds.clone();
        }
    }
}

