/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.displays;

import com.google.common.collect.Lists;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8824;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.*;

public class DefaultInformationDisplay implements Display {
    public static final DisplaySerializer<DefaultInformationDisplay> SERIALIZER = DisplaySerializer.of(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    EntryIngredient.codec().fieldOf("stacks").forGetter(DefaultInformationDisplay::getEntryStacks),
                    class_8824.field_46597.fieldOf("name").forGetter(DefaultInformationDisplay::getName),
                    class_8824.field_46597.listOf().fieldOf("texts").forGetter(DefaultInformationDisplay::getTexts)
            ).apply(instance, (stacks, name, texts) -> new DefaultInformationDisplay(stacks, name).lines(texts))),
            class_9139.method_56436(
                    EntryIngredient.streamCodec(),
                    DefaultInformationDisplay::getEntryStacks,
                    class_8824.field_48540,
                    DefaultInformationDisplay::getName,
                    class_8824.field_48540.method_56433(class_9135.method_56363()),
                    DefaultInformationDisplay::getTexts,
                    (stacks, name, texts) -> new DefaultInformationDisplay(stacks, name).lines(texts)
            ));
    
    private final EntryIngredient entryStacks;
    private final List<class_2561> texts;
    private final class_2561 name;
    
    protected DefaultInformationDisplay(EntryIngredient entryStacks, class_2561 name) {
        this.entryStacks = entryStacks;
        this.name = name;
        this.texts = Lists.newArrayList();
    }
    
    public static DefaultInformationDisplay createFromEntries(EntryIngredient entryStacks, class_2561 name) {
        return new DefaultInformationDisplay(entryStacks, name);
    }
    
    public static DefaultInformationDisplay createFromEntry(EntryStack<?> entryStack, class_2561 name) {
        return createFromEntries(EntryIngredient.of(entryStack), name);
    }
    
    @Override
    public List<EntryIngredient> getInputEntries() {
        return Collections.singletonList(entryStacks);
    }
    
    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(entryStacks);
    }
    
    public DefaultInformationDisplay line(class_2561 line) {
        texts.add(line);
        return this;
    }
    
    public DefaultInformationDisplay lines(class_2561... lines) {
        texts.addAll(Arrays.asList(lines));
        return this;
    }
    
    public DefaultInformationDisplay lines(Collection<class_2561> lines) {
        texts.addAll(lines);
        return this;
    }
    
    public EntryIngredient getEntryStacks() {
        return entryStacks;
    }
    
    public class_2561 getName() {
        return name;
    }
    
    public List<class_2561> getTexts() {
        return texts;
    }
    
    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.INFO;
    }
    
    @Override
    public Optional<class_2960> getDisplayLocation() {
        return Optional.empty();
    }
    
    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
