/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import com.mojang.datafixers.util.Pair;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1848;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import java.util.*;

public class BannerDuplicateRecipeFiller implements CraftingRecipeFiller<class_1848> {
    @Override
    public Collection<Display> apply(class_8786<class_1848> recipe) {
        List<Display> displays = new ArrayList<>();
        Map<class_1767, Pair<EntryIngredient.Builder, EntryStack<?>>> displayMap = new HashMap<>();
        
        for (Pair<class_1767, class_1799> pair : ShieldDecorationRecipeFiller.randomizeBanners()) {
            Optional<class_1792> bannerOptional = class_7923.field_41178.method_17966(class_2960.method_60654(pair.getFirst().method_7792() + "_banner"));
            if (bannerOptional.isEmpty()) continue;
            Pair<EntryIngredient.Builder, EntryStack<?>> builderPair = displayMap.computeIfAbsent(pair.getFirst(), color -> Pair.of(EntryIngredient.builder(), EntryStacks.of(bannerOptional.get())));
            builderPair.getFirst().add(EntryStacks.of(pair.getSecond()));
        }
        
        for (Pair<EntryIngredient.Builder, EntryStack<?>> pair : displayMap.values()) {
            EntryIngredient inputsFirst = pair.getFirst().build();
            EntryStack<?> inputsSecond = pair.getSecond();
            EntryIngredient.unifyFocuses(inputsFirst);
            displays.add(new DefaultCustomShapelessDisplay(
                    List.of(inputsFirst, EntryIngredient.of(inputsSecond)),
                    List.of(inputsFirst),
                    Optional.of(recipe.comp_1932().method_29177())));
        }
        
        return displays;
    }
    
    @Override
    public Class<class_1848> getRecipeClass() {
        return class_1848.class;
    }
}
