/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.transfer;

import com.google.common.collect.Iterators;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.class_5632;
import org.jetbrains.annotations.ApiStatus;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

@ApiStatus.Internal
public class TransferHandlerRegistryImpl implements TransferHandlerRegistry {
    private final List<TransferHandler> handlers = new ArrayList<>();
    
    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerTransferHandlers(this);
    }
    
    @Override
    public void startReload() {
        handlers.clear();
    }
    
    @Override
    public void endReload() {
        InternalLogger.getInstance().debug("Registered %d transfer handlers", handlers.size());
    }
    
    @Override
    public void register(TransferHandler handler) {
        handlers.add(handler);
        handlers.sort(Comparator.reverseOrder());
        InternalLogger.getInstance().debug("Added transfer handler: %s [%.2f priority]", handler, handler.getPriority());
    }
    
    @Override
    public Iterator<TransferHandler> iterator() {
        return Iterators.unmodifiableIterator(handlers.iterator());
    }
    
    static {
        ClientInternals.attachInstance((Function<List<EntryIngredient>, class_5632>) MissingStacksTooltip::new, "missingTooltip");
    }
}
