/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import net.minecraft.class_5684;

public class CollapsedEntriesTooltip implements class_5684, class_5632 {
    private static final int MAX_WIDTH = 140;
    private final CollapsedStack stack;
    
    public CollapsedEntriesTooltip(CollapsedStack stack) {
        this.stack = stack;
    }
    
    @Override
    public int method_32661(class_327 font) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, MAX_WIDTH / entrySize);
        return Math.min(3, class_3532.method_15386(stack.getIngredient().size() / (float) w)) * entrySize + 2;
    }
    
    @Override
    public int method_32664(class_327 font) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, MAX_WIDTH / entrySize);
        int size = stack.getIngredient().size();
        return Math.min(size, w) * entrySize;
    }
    
    @Override
    public void method_32666(class_327 font, int x, int y, int weight, int height, class_332 graphics) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, MAX_WIDTH / entrySize);
        int i = 0;
        for (EntryStack<?> entry : stack.getIngredient()) {
            int x1 = x + (i % w) * entrySize;
            int y1 = y + (i / w) * entrySize;
            i++;
            if (i / w > 3 - 1) {
                class_2561 text = class_2561.method_43470("+" + (stack.getIngredient().size() - w * 3 + 1)).method_27692(class_124.field_1080);
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate(x1 + entrySize / 2 - font.method_27525(text) / 2, y1 + entrySize / 2 - 1);
                graphics.method_27535(font, text, 0, 0, -1);
                graphics.method_51448().popMatrix();
                break;
            } else {
                entry.render(graphics, new Rectangle(x1, y1, entrySize, entrySize), -1000, -1000, 0);
            }
        }
    }
}
