/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.ItemCheatingMode;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class DisplayedEntryWidget extends EntryWidget {
    public int backupY;
    
    protected DisplayedEntryWidget(Point point, int entrySize) {
        super(point);
        this.backupY = point.y;
        getBounds().width = getBounds().height = entrySize;
    }
    
    @Override
    protected void drawHighlighted(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!getCurrentEntry().isEmpty())
            super.drawHighlighted(graphics, mouseX, mouseY, delta);
    }
    
    @Override
    public void queueTooltip(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (ClientHelper.getInstance().isCheating() && !(class_310.method_1551().field_1755 instanceof DisplayScreen) && !minecraft.field_1724.field_7512.method_34255().method_7960()) {
            return;
        }
        super.queueTooltip(graphics, mouseX, mouseY, delta);
    }
    
    @Override
    protected boolean doAction(class_11909 event) {
        if (ClientHelper.getInstance().isCheating() && !event.method_74240() && !(class_310.method_1551().field_1755 instanceof DisplayScreen)) {
            EntryStack<?> entry = getCurrentEntry().copy();
            if (!entry.isEmpty()) {
                if (entry.getType() != VanillaEntryTypes.ITEM) {
                    EntryStack<class_1799> cheatsAs = entry.cheatsAs();
                    entry = cheatsAs.isEmpty() ? entry : cheatsAs;
                }
                if (entry.getValueType() == class_1799.class) {
                    boolean all;
                    if (ConfigObject.getInstance().getItemCheatingMode() == ItemCheatingMode.REI_LIKE) {
                        all = event.method_74245() == 1 || event.method_74239();
                    } else {
                        all = event.method_74245() != 1 || event.method_74239();
                    }
                    entry.<class_1799>castValue().method_7939(!all ? 1 : entry.<class_1799>castValue().method_7914());
                }
                return ClientHelper.getInstance().tryCheatingEntry(entry);
            }
        }
        
        return super.doAction(event);
    }
    
    @Override
    public boolean cancelDeleteItems(EntryStack<?> stack) {
        if (!interactable || !ConfigObject.getInstance().isGrabbingItems())
            return super.cancelDeleteItems(stack);
        if (ClientHelper.getInstance().isCheating() && !class_310.method_1551().method_74188() && !(class_310.method_1551().field_1755 instanceof DisplayScreen)) {
            EntryStack<?> entry = getCurrentEntry().copy();
            if (!entry.isEmpty()) {
                if (entry.getType() != VanillaEntryTypes.ITEM) {
                    EntryStack<class_1799> cheatsAs = entry.cheatsAs();
                    entry = cheatsAs.isEmpty() ? entry : cheatsAs;
                }
                return EntryStacks.equalsExact(entry, stack);
            }
        }
        return super.cancelDeleteItems(stack);
    }
    
    @Override
    public boolean keyPressedIgnoreContains(class_11908 event) {
        if (ClientHelper.getInstance().isCheating() && !(class_310.method_1551().field_1755 instanceof DisplayScreen)) {
            EntryStack<?> entry = getCurrentEntry().copy();
            if (!entry.isEmpty()) {
                if (entry.getType() != VanillaEntryTypes.ITEM) {
                    EntryStack<class_1799> cheatsAs = entry.cheatsAs();
                    entry = cheatsAs.isEmpty() ? entry : cheatsAs;
                }
                if (entry.getValueType() == class_1799.class) {
                    entry.<class_1799>castValue().method_7939(entry.<class_1799>castValue().method_7914());
                    
                    class_304[] keyHotbarSlots = class_310.method_1551().field_1690.field_1852;
                    for (int i = 0; i < keyHotbarSlots.length; i++) {
                        if (keyHotbarSlots[i].method_1417(event)) {
                            return ClientHelper.getInstance().tryCheatingEntryTo(entry, i);
                        }
                    }
                }
            }
        }
        
        return super.keyPressedIgnoreContains(event);
    }
}
