/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.api.client.gui.widgets;

import me.shedaniel.math.Rectangle;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

public class DelegateWidget extends WidgetWithBounds {
    private static final Rectangle EMPTY = new Rectangle();
    protected final Widget widget;
    
    public DelegateWidget(Widget widget) {
        this.widget = widget;
    }
    
    protected Widget delegate() {
        return widget;
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        delegate().method_25394(graphics, mouseX, mouseY, delta);
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return Collections.singletonList(delegate());
    }
    
    @Override
    public Rectangle getBounds() {
        return delegate() instanceof WidgetWithBounds withBounds ? withBounds.getBounds() : EMPTY;
    }
    
    @Nullable
    @Override
    public class_364 method_25399() {
        return delegate();
    }
    
    @Override
    public void method_25395(@Nullable class_364 guiEventListener) {
        Widget delegate = delegate();
        if (guiEventListener == delegate) {
            super.method_25395(delegate);
        } else {
            delegate.method_25395(guiEventListener);
        }
    }
    
    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return delegate().containsMouse(mouseX, mouseY);
    }
    
    @Override
    public boolean method_25397() {
        return true;
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        return delegate().method_25401(mouseX, mouseY, amountX, amountY);
    }
    
    @Override
    public boolean method_25404(class_11908 event) {
        return delegate().method_25404(event);
    }
    
    @Override
    public boolean method_16803(class_11908 event) {
        return delegate().method_16803(event);
    }
    
    @Override
    public boolean method_25400(class_11905 event) {
        return delegate().method_25400(event);
    }
    
    @Override
    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        return delegate().method_25403(event, deltaX, deltaY);
    }
    
    @Override
    public boolean method_25406(class_11909 event) {
        this.method_25398(false);
        return delegate().method_25406(event);
    }
    
    @Override
    public double getZRenderingPriority() {
        return delegate().getZRenderingPriority();
    }
}
