/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.registry.displays;

import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.GameInstance;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.networking.DisplaySyncPacket;
import me.shedaniel.rei.impl.common.plugins.ReloadManagerImpl;
import me.shedaniel.rei.impl.common.registry.displays.AbstractDisplayRegistry;
import me.shedaniel.rei.impl.common.registry.displays.DisplayConsumerImpl;
import me.shedaniel.rei.impl.common.registry.displays.DisplaysHolderImpl;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class ServerDisplayRegistryImpl
extends AbstractDisplayRegistry<REICommonPlugin, ServerDisplaysHolder>
implements ServerDisplayRegistry,
DisplayConsumerImpl {
    private static final Comparator<class_8786<?>> RECIPE_COMPARATOR = Comparator.comparing(o -> o.comp_1932().method_29177().method_12836()).thenComparing(o -> o.comp_1932().method_29177().method_12832());
    private final Object2LongMap<UUID> playerVersionMap = new Object2LongOpenHashMap();
    private int reloadVersionHash = UUID.randomUUID().hashCode();

    public ServerDisplayRegistryImpl() {
        super(ServerDisplaysHolder::new);
        int[] tick = new int[]{0};
        TickEvent.SERVER_POST.register(instance -> {
            int n = tick[0];
            tick[0] = n + 1;
            if (n % 2 == 0 && !PluginManager.areAnyReloading() && ReloadManagerImpl.countRunningReloadTasks() == 0) {
                long version = this.currentVersion();
                ((ServerDisplaysHolder)this.holder()).everySecond();
                long currentVersion = this.currentVersion();
                if (version != currentVersion) {
                    InternalLogger.getInstance().debug("Updating players with new displays version %X [from %X]", currentVersion, version);
                    this.updatePlayers((class_5455)instance.method_30611(), CollectionUtils.filterToList(instance.method_3760().method_14571(), player -> NetworkManager.canPlayerReceive((class_3222)player, DisplaySyncPacket.TYPE)));
                    return;
                }
                ArrayList<class_3222> toUpdate = new ArrayList<class_3222>();
                for (class_3222 player2 : instance.method_3760().method_14571()) {
                    long versionHash;
                    if (!NetworkManager.canPlayerReceive((class_3222)player2, DisplaySyncPacket.TYPE) || (versionHash = this.playerVersionMap.getLong((Object)player2.method_5667())) == currentVersion) continue;
                    InternalLogger.getInstance().debug("Player %s has outdated displays version %X [latest version: %X]", player2.method_7334().name(), versionHash, currentVersion);
                    toUpdate.add(player2);
                }
                if (!toUpdate.isEmpty()) {
                    this.updatePlayers((class_5455)instance.method_30611(), toUpdate);
                }
            }
        });
        PlayerEvent.PLAYER_JOIN.register(player -> this.playerVersionMap.put((Object)player.method_5667(), 0L));
        PlayerEvent.PLAYER_QUIT.register(player -> this.playerVersionMap.removeLong((Object)player.method_5667()));
    }

    private void updatePlayers(class_5455 registryAccess, List<class_3222> players) {
        Supplier resetPacket = Suppliers.memoize(() -> this.getResetPackets(registryAccess));
        HashMap updatesMap = new HashMap();
        Function<IntIntPair, List> updatePackets = pair -> updatesMap.computeIfAbsent(pair, $ -> this.getUpdatePackets(registryAccess, pair.leftInt(), pair.rightInt()));
        long version = this.currentVersion();
        for (class_3222 player : players) {
            long playerVersion = this.playerVersionMap.getLong((Object)player.method_5667());
            long playerReloadHash = playerVersion >>> 32;
            this.playerVersionMap.put((Object)player.method_5667(), version);
            if (playerReloadHash != (long)this.reloadVersionHash) {
                InternalLogger.getInstance().debug("Player %s has outdated displays version %X [latest version: %X], sending reset packet request.", player.method_7334().name(), playerVersion, version);
                for (class_2596 packet : (List)resetPacket.get()) {
                    player.field_13987.method_14364(packet);
                }
                continue;
            }
            if (playerVersion == version) continue;
            int playerMinorVersion = (int)playerVersion;
            int currentMinorVersion = (int)version;
            if (playerMinorVersion > currentMinorVersion) {
                InternalLogger.getInstance().debug("Player %s has too new displays version %X [latest version: %X], sending reset packet request.", player.method_7334().name(), playerVersion, version);
                for (class_2596 packet : (List)resetPacket.get()) {
                    player.field_13987.method_14364(packet);
                }
                continue;
            }
            InternalLogger.getInstance().debug("Player %s has outdated displays version %X [latest version: %X], sending update packets.", player.method_7334().name(), playerVersion, version);
            for (class_2596 packet : updatePackets.apply(IntIntPair.of((int)playerMinorVersion, (int)currentMinorVersion))) {
                player.field_13987.method_14364(packet);
            }
        }
    }

    private List<class_2596<?>> getResetPackets(class_5455 registryAccess) {
        final List<Set<Display>> displays = ((ServerDisplaysHolder)this.holder()).displaysByVersion;
        if (displays.isEmpty() || displays.size() == 1 && displays.get(0).isEmpty()) {
            return List.of();
        }
        ArrayList packets = new ArrayList();
        NetworkManager.collectPackets(packets::add, (NetworkManager.Side)NetworkManager.s2c(), (class_8710)new DisplaySyncPacket(DisplaySyncPacket.SyncType.SET, (Collection<Display>)new AbstractCollection<Display>(this){

            @Override
            public Iterator<Display> iterator() {
                return displays.stream().flatMap(Collection::stream).iterator();
            }

            @Override
            public int size() {
                return displays.stream().mapToInt(Set::size).sum();
            }
        }, this.currentVersion()), (class_5455)registryAccess);
        return packets;
    }

    private List<class_2596<?>> getUpdatePackets(class_5455 registryAccess, int from, int to) {
        final List<Set<Display>> displays = ((ServerDisplaysHolder)this.holder()).displaysByVersion.subList(from, to);
        if (displays.isEmpty() || displays.size() == 1 && displays.get(0).isEmpty()) {
            return List.of();
        }
        ArrayList packets = new ArrayList();
        NetworkManager.collectPackets(packets::add, (NetworkManager.Side)NetworkManager.s2c(), (class_8710)new DisplaySyncPacket(DisplaySyncPacket.SyncType.APPEND, (Collection<Display>)new AbstractCollection<Display>(this){

            @Override
            public Iterator<Display> iterator() {
                return displays.stream().flatMap(Collection::stream).iterator();
            }

            @Override
            public int size() {
                return displays.stream().mapToInt(Set::size).sum();
            }
        }, this.currentVersion()), (class_5455)registryAccess);
        return packets;
    }

    @Override
    public void startReload() {
        this.reloadVersionHash = UUID.randomUUID().hashCode();
        super.startReload();
    }

    private long currentVersion() {
        return (long)this.reloadVersionHash << 32 | (long)((ServerDisplaysHolder)this.holder()).displaysByVersion.size();
    }

    @Override
    public void acceptPlugin(REICommonPlugin plugin) {
        plugin.registerDisplays(this);
    }

    @Override
    public boolean add(Display display, @Nullable Object origin) {
        if (DisplaySerializerRegistry.getInstance().isRegistered(display.getSerializer())) {
            return super.add(display, origin);
        }
        InternalLogger.getInstance().throwException(new IllegalStateException("Tried to add display [%s] with unregistered serializer: %s".formatted(display, display.getSerializer())));
        return false;
    }

    @Override
    public void endReload() {
        InternalLogger.getInstance().debug("Found preliminary %d displays", this.size());
        this.fillRecipes();
    }

    private void fillRecipes() {
        if (GameInstance.getServer() == null) {
            InternalLogger.getInstance().debug("Skipping recipe fill: server not available");
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        int lastSize = this.size();
        if (!this.fillers().isEmpty()) {
            List<class_8786<?>> allSortedRecipes = this.getAllSortedRecipes();
            for (int i = allSortedRecipes.size() - 1; i >= 0; --i) {
                class_8786<?> recipe = allSortedRecipes.get(i);
                try {
                    this.addWithReason(recipe, DisplayAdditionReason.RECIPE_MANAGER);
                    continue;
                }
                catch (Throwable e) {
                    InternalLogger.getInstance().error("Failed to fill display for recipe: %s [%s]", recipe.comp_1933(), recipe.comp_1932(), e);
                }
            }
        }
        InternalLogger.getInstance().debug("Filled %d displays from recipe manager in %s", this.size() - lastSize, stopwatch.stop());
    }

    private List<class_8786<?>> getAllSortedRecipes() {
        return GameInstance.getServer().method_3772().method_8126().parallelStream().sorted(RECIPE_COMPARATOR).toList();
    }

    public static class ServerDisplaysHolder
    extends DisplaysHolderImpl {
        private final List<Set<Display>> displaysByVersion = new ArrayList<Set<Display>>();
        private final Set<Display> pendingDisplays = new ReferenceOpenHashSet();
        private int timeUntilCollection = 0;

        @Override
        public void add(Display display, @Nullable Object origin) {
            super.add(display, origin);
            this.pendingDisplays.add(display);
            this.timeUntilCollection = 10;
        }

        @Override
        protected void removeFallout(Display display) {
            this.pendingDisplays.remove(display);
            this.displaysByVersion.forEach(set -> set.remove(display));
        }

        private void everySecond() {
            if (this.timeUntilCollection > 0 && --this.timeUntilCollection <= 0) {
                this.displaysByVersion.add((Set<Display>)new ReferenceOpenHashSet(this.pendingDisplays));
                this.pendingDisplays.clear();
            }
        }
    }
}

