/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.util;

import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.impl.client.gui.widget.CatchingExceptionUtils;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class CrashReportUtils {
    public static class_128 essential(Throwable throwable, String task) {
        Throwable temp = throwable;
        while (temp != null) {
            temp = temp.getCause();
            if (temp instanceof class_148) {
                return essential(temp, task);
            }
        }
        class_128 report = class_128.method_560(throwable, task);
        screen(report, class_310.method_1551().field_1755);
        return report;
    }
    
    private static void screen(class_128 report, class_437 screen) {
        if (screen != null) {
            class_129 category = report.method_562("Screen details");
            String screenName = screen.getClass().getCanonicalName();
            category.method_577("Screen name", () -> screenName);
        }
    }
    
    public static void renderer(class_128 report, Renderer renderer) {
        if (renderer != null) {
            class_129 category = report.method_562("Renderer details");
            try {
                renderer.fillCrashReport(report, category);
            } catch (Throwable throwable) {
                category.method_585("Filling Report", throwable);
            }
        }
    }
    
    public static class_148 throwReport(class_128 report) {
        return new class_148(report);
    }
    
    public static void catchReport(class_128 report) {
        CatchingExceptionUtils.handleThrowable(new class_148(report), report.method_561());
    }
}
