/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import java.util.*;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AutoCraftingEvaluator {
    public static class AutoCraftingResult {
        public int tint = 0;
        public boolean successful = false;
        public TransferHandler successfulHandler;
        public boolean hasApplicable = false;
        public TransferHandlerRenderer renderer;
        public BiConsumer<Point, Consumer<Tooltip>> tooltipRenderer;
    }
    
    public static AutoCraftingResult evaluateAutoCrafting(boolean actuallyCrafting, boolean stackedCrafting, Display display, Supplier<Collection<class_2960>> idsSupplier) {
        class_465<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        AutoCraftingResult result = new AutoCraftingResult();
        final List<Tooltip.Entry> errorTooltip = new ArrayList<>();
        result.tooltipRenderer = (pos, sink) -> {
            List<Tooltip.Entry> str = new ArrayList<>(errorTooltip);
            
            if (ConfigObject.getInstance().isFavoritesEnabled()) {
                str.add(Tooltip.entry(class_2561.method_43470(" ")));
                str.add(Tooltip.entry(class_2561.method_43469("text.rei.save.recipes", class_2561.method_43470(ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString().toUpperCase(Locale.ROOT)).method_27692(class_124.field_1067)).method_27692(class_124.field_1080)));
            }
            
            if (class_310.method_1551().field_1690.field_1827 && idsSupplier != null) {
                Collection<class_2960> locations = idsSupplier.get();
                if (!locations.isEmpty()) {
                    str.add(Tooltip.entry(class_2561.method_43470(" ")));
                    for (class_2960 location : locations) {
                        String t = class_1074.method_4662("text.rei.recipe_id", "", location.toString());
                        if (t.startsWith("\n")) {
                            t = t.substring("\n".length());
                        }
                        str.add(Tooltip.entry(class_2561.method_43470(t).method_27692(class_124.field_1080)));
                    }
                }
            }
            
            sink.accept(Tooltip.from(pos, str));
        };
        
        if (containerScreen == null) {
            errorTooltip.add(Tooltip.entry(class_2561.method_43471("error.rei.not.supported.move.items").method_27692(class_124.field_1061)));
            return result;
        }
        
        List<TransferHandler.Result> errors = new ArrayList<>();
        TransferHandler.Result successfulResult = null;
        TransferHandler.Context context = TransferHandler.Context.create(actuallyCrafting, stackedCrafting, containerScreen, display);
        
        for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
            try {
                TransferHandler.ApplicabilityResult applicabilityResult = transferHandler.checkApplicable(context);
                if (!applicabilityResult.isApplicable()) continue;
                TransferHandler.Result transferResult;
                
                if (applicabilityResult.isSuccessful()) {
                    transferResult = transferHandler.handle(context);
                } else {
                    transferResult = applicabilityResult.getError();
                }
                
                if (transferResult.isBlocking() && actuallyCrafting) {
                    if (transferResult.isReturningToScreen()) {
                        class_310.method_1551().method_1507(containerScreen);
                        REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    }
                    
                    break;
                }
                
                if (transferResult.isApplicable()) {
                    result.hasApplicable = true;
                    result.tint = transferResult.getColor();
                    
                    TransferHandlerRenderer transferHandlerRenderer = transferResult.getRenderer(transferHandler, context);
                    if (transferHandlerRenderer != null) {
                        result.renderer = transferHandlerRenderer;
                    }
                    
                    if (transferResult.getTooltipRenderer() != null) {
                        BiConsumer<Point, TransferHandler.Result.TooltipSink> tooltipRenderer = transferResult.getTooltipRenderer();
                        result.tooltipRenderer = (point, tooltipConsumer) -> tooltipRenderer.accept(point, tooltipConsumer::accept);
                    }
                    
                    if (transferResult.isSuccessful()) {
                        errors.clear();
                        successfulResult = transferResult;
                        result.successful = true;
                        result.successfulHandler = transferHandler;
                        break;
                    }
                    
                    errors.add(transferResult);
                    
                    if (transferResult.isBlocking()) {
                        break;
                    }
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
        
        if (!result.hasApplicable) {
            errorTooltip.clear();
            errorTooltip.add(Tooltip.entry(class_2561.method_43471("error.rei.not.supported.move.items").method_27692(class_124.field_1061)));
            return result;
        }
        
        if (errors.isEmpty()) {
            errorTooltip.clear();
            errorTooltip.add(Tooltip.entry(class_2561.method_43471("text.auto_craft.move_items")));
            
            if (successfulResult != null) {
                successfulResult.fillTooltip(errorTooltip);
            }
        } else {
            errorTooltip.clear();
            List<Tooltip.Entry> tooltipsFilled = new ArrayList<>();
            for (TransferHandler.Result error : errors) {
                error.fillTooltip(tooltipsFilled);
            }
            
            if (errors.size() == 1) {
                for (Tooltip.Entry tooltipFilled : tooltipsFilled) {
                    if (tooltipFilled.isText()) {
                        class_5250 colored = tooltipFilled.getAsText().method_27661().method_27692(class_124.field_1061);
                        if (!CollectionUtils.anyMatch(errorTooltip, ss -> ss.isText() && ss.getAsText().getString().equalsIgnoreCase(colored.getString()))) {
                            errorTooltip.add(Tooltip.entry(colored));
                        }
                    } else {
                        errorTooltip.add(tooltipFilled);
                    }
                }
            } else {
                errorTooltip.add(Tooltip.entry(class_2561.method_43471("error.rei.multi.errors").method_27692(class_124.field_1061)));
                for (Tooltip.Entry tooltipFilled : tooltipsFilled) {
                    if (tooltipFilled.isText()) {
                        class_5250 colored = class_2561.method_43470("- ").method_27692(class_124.field_1061)
                                .method_10852(tooltipFilled.getAsText().method_27661().method_27692(class_124.field_1061));
                        if (!CollectionUtils.anyMatch(errorTooltip, ss -> ss.isText() && ss.getAsText().getString().equalsIgnoreCase(colored.getString()))) {
                            errorTooltip.add(Tooltip.entry(colored));
                        }
                    } else {
                        errorTooltip.add(tooltipFilled);
                    }
                }
            }
        }
        
        return result;
    }
}
