/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.screen;

import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8012;
import net.minecraft.util.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

@ApiStatus.Internal
public class ConfigReloadingScreen extends class_437 {
    private final class_2561 field_22785;
    private final BooleanSupplier predicate;
    private Supplier<@Nullable class_2561> subtitle = () -> null;
    private final Runnable parent;
    private final Runnable cancel;
    
    public ConfigReloadingScreen(class_2561 title, BooleanSupplier predicate, Runnable parent, Runnable cancel) {
        super(class_2561.method_43473());
        this.field_22785 = title;
        this.predicate = predicate;
        this.parent = parent;
        this.cancel = cancel;
    }
    
    public void setSubtitle(Supplier<@Nullable class_2561> subtitle) {
        this.subtitle = subtitle;
    }
    
    @Override
    public boolean method_25422() {
        return false;
    }
    
    @Override
    public void method_25426() {
        super.method_25426();
        if (cancel == null) return;
        this.method_37063(class_4185.method_46430(class_5244.field_24335, button -> {
            cancel.run();
        }).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 120 + 12, 200, 20).method_46431());
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (!predicate.getAsBoolean()) {
            parent.run();
            return;
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
        String text = switch ((int) (class_156.method_658() / 300L % 4L)) {
            case 1, 3 -> "o O o";
            case 2 -> "o o O";
            default -> "O o o";
        };
        class_2561 subtitle = this.subtitle.get();
        int width = Math.max(field_22793.method_1727(text), field_22793.method_27525(field_22785)), height = subtitle == null ? 18 : 27;
        if (subtitle != null) width = Math.max(width, field_22793.method_27525(subtitle));
        int x = this.field_22789 / 2 - width / 2;
        int k = x - 12;
        int l = this.field_22790 / 2 - height / 2 - 12;
        int m = width + 12 * 2;
        int n = height + 12 * 2;
        int o = this.method_25370() ? -1 : -6250336;
        graphics.method_25294(k + 1, l, k + m, l + n, -16777216);
        graphics.method_73198(k, l, m, n, o);
        graphics.method_27534(this.field_22793, field_22785, this.field_22789 / 2, l + 12, class_8012.field_42973);
        graphics.method_25300(this.field_22793, text, this.field_22789 / 2, l + 12 + 9, 0xFF808080);
        if (subtitle != null) {
            graphics.method_27534(this.field_22793, subtitle, this.field_22789 / 2, l + 12 + 9 + 9, 0xFF808080);
        }
    }
}
