/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.fabric;

import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_5321;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import java.util.*;

public class CreativeModeTabCollectorImpl {
    public static Map<class_1761, Collection<class_1799>> collectTabs() {
        Map<class_1761, Collection<class_1799>> map = new LinkedHashMap<>();
        class_7699 featureFlags = class_7701.field_40180.method_45383();
        class_1761.class_8128 parameters = new class_1761.class_8128(featureFlags, true, BasicDisplay.registryAccess());
        
        for (class_1761 tab : class_7706.method_47341()) {
            if (tab.method_47312() != class_1761.class_7916.field_41054 && tab.method_47312() != class_1761.class_7916.field_41053) {
                try {
                    class_1761.class_7703 builder = new class_1761.class_7703(tab, featureFlags);
                    class_5321<class_1761> resourceKey = class_7923.field_44687
                            .method_29113(tab)
                            .orElseThrow(() -> new IllegalStateException("Unregistered creative tab: " + tab));
                    tab.field_41037.accept(parameters, builder);
                    map.put(tab, postFabricEvents(tab, parameters, resourceKey, builder.field_40187));
                } catch (Throwable throwable) {
                    InternalLogger.getInstance().error("Failed to collect creative tab: " + tab, throwable);
                }
            }
        }
        
        return map;
    }
    
    @SuppressWarnings("UnstableApiUsage")
    private static Collection<class_1799> postFabricEvents(class_1761 tab, class_1761.class_8128 parameters, class_5321<class_1761> resourceKey, Collection<class_1799> tabContents) {
        try {
            // Sorry!
            FabricItemGroupEntries entries = new FabricItemGroupEntries(parameters, new LinkedList<>(tabContents), new LinkedList<>());
            ItemGroupEvents.modifyEntriesEvent(resourceKey).invoker().modifyEntries(entries);
            ItemGroupEvents.MODIFY_ENTRIES_ALL.invoker().modifyEntries(tab, entries);
            return entries.getDisplayStacks();
        } catch (Throwable throwable) {
            InternalLogger.getInstance().error("Failed to collect fabric's creative tab: " + tab, throwable);
            return tabContents;
        }
    }
}
