/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.SplitPacketTransformer;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.Unpooled;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.impl.common.networking.DisplaySyncPacket;
import me.shedaniel.rei.impl.common.transfer.InputSlotCrafter;
import me.shedaniel.rei.impl.common.transfer.NewInputSlotCrafter;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1729;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5455;
import net.minecraft.class_9129;
import net.minecraft.server.*;
import net.minecraft.server.permissions.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RoughlyEnoughItemsNetwork {
    public static final class_2960 DELETE_ITEMS_PACKET = class_2960.method_60655("roughlyenoughitems", "delete_item");
    public static final class_2960 CREATE_ITEMS_PACKET = class_2960.method_60655("roughlyenoughitems", "create_item");
    public static final class_2960 CREATE_ITEMS_HOTBAR_PACKET = class_2960.method_60655("roughlyenoughitems", "create_item_hotbar");
    public static final class_2960 CREATE_ITEMS_GRAB_PACKET = class_2960.method_60655("roughlyenoughitems", "create_item_grab");
    public static final class_2960 CREATE_ITEMS_MESSAGE_PACKET = class_2960.method_60655("roughlyenoughitems", "ci_msg");
    public static final class_2960 MOVE_ITEMS_NEW_PACKET = class_2960.method_60655("roughlyenoughitems", "move_items_new");
    public static final class_2960 NOT_ENOUGH_ITEMS_PACKET = class_2960.method_60655("roughlyenoughitems", "og_not_enough");
    public static final class_2960 SYNC_DISPLAYS_PACKET = class_2960.method_60655("roughlyenoughitems", "sync_displays");
    
    public static void onInitialize() {
        NetworkManager.registerReceiver(NetworkManager.c2s(), DELETE_ITEMS_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            class_3222 player = (class_3222) context.getPlayer();
            if (!player.method_75004().hasPermission(new class_12087.class_12089(class_12094.field_63198))) {
                player.method_7353(class_2561.method_43471("text.rei.no_permission_cheat").method_27692(class_124.field_1061), false);
                return;
            }
            class_1703 menu = player.field_7512;
            if (!menu.method_34255().method_7960()) {
                menu.method_34254(class_1799.field_8037);
                menu.method_7623();
            }
        });
        NetworkManager.registerReceiver(NetworkManager.c2s(), CREATE_ITEMS_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            class_3222 player = (class_3222) context.getPlayer();

            if (!player.method_75004().hasPermission(new class_12087.class_12089(class_12094.field_63198))) {
                player.method_7353(class_2561.method_43471("text.rei.no_permission_cheat").method_27692(class_124.field_1061), false);
                return;
            }
            class_1799 stack = buf.method_49394(class_1799.field_49266);
            if (player.method_31548().method_7394(stack.method_7972())) {
                class_9129 newBuf = new class_9129(Unpooled.buffer(), player.method_56673());
                newBuf.method_49395(class_1799.field_49266, stack.method_7972());
                newBuf.method_10788(player.method_5820(), 32767);
                NetworkManager.sendToPlayer(player, RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, newBuf);
            } else {
                player.method_7353(class_2561.method_43471("text.rei.failed_cheat_items"), false);
            }
        });
        NetworkManager.registerReceiver(NetworkManager.c2s(), CREATE_ITEMS_GRAB_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            class_3222 player = (class_3222) context.getPlayer();
            if (!player.method_75004().hasPermission(new class_12087.class_12089(class_12094.field_63198))) {
                player.method_7353(class_2561.method_43471("text.rei.no_permission_cheat").method_27692(class_124.field_1061), false);
                return;
            }
            
            class_1703 menu = player.field_7512;
            class_1799 itemStack = buf.method_49394(class_1799.field_49266);
            class_1799 stack = itemStack.method_7972();
            if (!menu.method_34255().method_7960() && class_1799.method_31577(menu.method_34255(), stack)) {
                stack.method_7939(class_3532.method_15340(stack.method_7947() + menu.method_34255().method_7947(), 1, stack.method_7914()));
            } else if (!menu.method_34255().method_7960()) {
                return;
            }
            menu.method_34254(stack.method_7972());
            menu.method_7623();
            class_9129 newBuf = new class_9129(Unpooled.buffer(), player.method_56673());
            newBuf.method_49395(class_1799.field_49266, stack.method_7972());
            newBuf.method_10788(player.method_5820(), 32767);
            NetworkManager.sendToPlayer(player, RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, newBuf);
        });
        NetworkManager.registerReceiver(NetworkManager.c2s(), CREATE_ITEMS_HOTBAR_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            class_3222 player = (class_3222) context.getPlayer();
            if (!player.method_75004().hasPermission(new class_12087.class_12089(class_12094.field_63198))) {
                player.method_7353(class_2561.method_43471("text.rei.no_permission_cheat").method_27692(class_124.field_1061), false);
                return;
            }
            class_1799 stack = buf.method_49394(class_1799.field_49266);
            int hotbarSlotId = buf.method_10816();
            if (hotbarSlotId >= 0 && hotbarSlotId < 9) {
                class_1703 menu = player.field_7512;
                player.method_31548().method_5447(hotbarSlotId, stack.method_7972());
                menu.method_7623();
                class_9129 newBuf = new class_9129(Unpooled.buffer(), player.method_56673());
                newBuf.method_49395(class_1799.field_49266, stack.method_7972());
                newBuf.method_10788(player.method_5820(), 32767);
                NetworkManager.sendToPlayer(player, RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, newBuf);
            } else {
                player.method_7353(class_2561.method_43471("text.rei.failed_cheat_items"), false);
            }
        });
        NetworkManager.registerReceiver(NetworkManager.c2s(), MOVE_ITEMS_NEW_PACKET, Collections.singletonList(new SplitPacketTransformer()), (packetByteBuf, context) -> {
            class_3222 player = (class_3222) context.getPlayer();
            CategoryIdentifier<Display> category = CategoryIdentifier.of(packetByteBuf.method_10810());
            class_1703 container = player.field_7512;
            class_1723 playerContainer = player.field_7498;
            try {
                boolean shift = packetByteBuf.readBoolean();
                try {
                    class_2487 nbt = packetByteBuf.method_10798();
                    int version = nbt.method_10550("Version").orElse(-1);
                    if (version != 1) throw new IllegalStateException("Server and client REI protocol version mismatch! Server: 1, Client: " + version);
                    List<InputIngredient<class_1799>> inputs = readInputs(context.registryAccess(), nbt.method_68569("Inputs"));
                    List<SlotAccessor> input = readSlots(container, player, nbt.method_68569("InputSlots"));
                    List<SlotAccessor> inventory = readSlots(container, player, nbt.method_68569("InventorySlots"));
                    NewInputSlotCrafter<class_1703, class_1263> crafter = new NewInputSlotCrafter<>(container, input, inventory, inputs);
                    crafter.fillInputSlots(player, shift);
                } catch (InputSlotCrafter.NotEnoughMaterialsException e) {
                    if (!(container instanceof class_1729)) {
                        return;
                    }
                } catch (IllegalStateException e) {
                    player.method_64398(class_2561.method_43471(e.getMessage()).method_27692(class_124.field_1061));
                } catch (Exception e) {
                    player.method_64398(class_2561.method_43469("error.rei.internal.error", e.getMessage()).method_27692(class_124.field_1061));
                    e.printStackTrace();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(DisplaySyncPacket.TYPE, DisplaySyncPacket.STREAM_CODEC, List.of(new SplitPacketTransformer()));
        }
    }
    
    private static List<SlotAccessor> readSlots(class_1703 menu, class_1657 player, class_2499 tag) {
        List<SlotAccessor> slots = new ArrayList<>();
        for (class_2520 t : tag) {
            slots.add(SlotAccessorRegistry.getInstance().read(menu, player, (class_2487) t));
        }
        return slots;
    }
    
    private static List<InputIngredient<class_1799>> readInputs(class_5455 registryAccess, class_2499 tag) {
        List<InputIngredient<class_1799>> inputs = new ArrayList<>();
        for (class_2520 t : tag) {
            class_2487 compoundTag = (class_2487) t;
            InputIngredient<EntryStack<?>> stacks = InputIngredient.of(compoundTag.method_10550("Index").orElseThrow(), EntryIngredient.codec().parse(registryAccess.method_57093(class_2509.field_11560), compoundTag.method_68569("Ingredient")).getOrThrow());
            inputs.add(InputIngredient.withType(stacks, VanillaEntryTypes.ITEM));
        }
        return inputs;
    }
}
