/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.CampfireDisplay;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;

public class DefaultCampfireCategory
implements DisplayCategory<CampfireDisplay> {
    public CategoryIdentifier<? extends CampfireDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.CAMPFIRE;
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)class_2246.field_17350);
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"category.rei.campfire");
    }

    public List<Widget> setupDisplay(CampfireDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(Widgets.createBurningFire((Point)new Point(startPoint.x + 1, startPoint.y + 20)).animationDurationMS(10000.0));
        if (display.cookTime().isPresent()) {
            widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 5, bounds.y + 5), (class_2561)class_2561.method_43469((String)"category.rei.campfire.time", (Object[])new Object[]{df.format(display.cookTime().getAsDouble() / 20.0)})).noShadow().rightAligned().color(-12566464, -4473925));
        }
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(display.cookTime().orElse(600.0)));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        return widgets;
    }

    public int getDisplayHeight() {
        return 49;
    }
}

