/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.GameType;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class GameModeFavoriteEntry
extends FavoriteEntry {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"gamemode");
    public static final String TRANSLATION_KEY = "favorite.section.gamemode";
    public static final String KEY = "mode";
    @Nullable
    private final GameType gameMode;

    public GameModeFavoriteEntry(@Nullable GameType gameMode) {
        this.gameMode = gameMode;
    }

    public boolean isInvalid() {
        return false;
    }

    public Renderer getRenderer(boolean showcase) {
        if (this.gameMode == null) {
            List renderers = IntStream.range(0, 4).mapToObj(GameModeFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(this, showcase, renderers, () -> Minecraft.getInstance().gameMode.getPlayerMode().getId()){

                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create((Point)context.getPoint(), (Component[])new Component[]{Component.translatable((String)"text.rei.gamemode_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(((Object)((Object)this)).getClass(), this.showcase);
                }
            };
        }
        return GameModeFavoriteEntry.getRenderer(this.gameMode.getId());
    }

    private static Renderer getRenderer(int id) {
        final GameType type = GameType.byId((int)id);
        return new Renderer(){

            public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    graphics.pose().pushMatrix();
                    graphics.pose().translate((float)bounds.getCenterX(), (float)bounds.getCenterY());
                    graphics.pose().scale((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f);
                    this.renderGameModeText(graphics, type, 0, 0, color);
                    graphics.pose().popMatrix();
                }
            }

            private void renderGameModeText(GuiGraphics graphics, GameType type2, int centerX, int centerY, int color) {
                MutableComponent s = Component.translatable((String)("text.rei.short_gamemode." + type2.getName()));
                Font font = Minecraft.getInstance().font;
                graphics.pose().pushMatrix();
                graphics.pose().translate((float)centerX - (float)font.width((FormattedText)s) / 2.0f + 0.5f, (float)centerY - 3.5f);
                graphics.drawString(font, (Component)s, 0, 0, color, false);
                graphics.pose().popMatrix();
            }

            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                return Tooltip.create((Point)context.getPoint(), (Component[])new Component[]{Component.translatable((String)"text.rei.gamemode_button.tooltip.entry", (Object[])new Object[]{type.getLongDisplayName().getString()})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(this.getClass(), false, type);
            }
        };
    }

    public boolean doAction(MouseButtonEvent event) {
        if (event.button() == 0) {
            GameType mode = this.gameMode;
            if (mode == null) {
                mode = GameType.byId((int)(Minecraft.getInstance().gameMode.getPlayerMode().getId() + 1));
            }
            Minecraft.getInstance().player.connection.sendCommand(StringUtils.removeStart((String)ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", mode.name().toLowerCase(Locale.ROOT)), (String)"/"));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return false;
    }

    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.gameMode == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.filterAndMap(Arrays.asList(GameType.values()), type -> type.getId() >= 0, GameModeMenuEntry::new);
    }

    public long hashIgnoreAmount() {
        return this.gameMode == null ? 31290831290L : (long)this.gameMode.ordinal();
    }

    public FavoriteEntry copy() {
        return this;
    }

    public ResourceLocation getType() {
        return ID;
    }

    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof GameModeFavoriteEntry)) {
            return false;
        }
        GameModeFavoriteEntry that = (GameModeFavoriteEntry)other;
        return Objects.equals(this.gameMode, that.gameMode);
    }

    public static class GameModeMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final GameType gameMode;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public GameModeMenuEntry(GameType gameMode) {
            this.text = gameMode.getLongDisplayName().getString();
            this.gameMode = gameMode;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.width(this.text));
            }
            return this.textWidth;
        }

        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        public int getEntryHeight() {
            return 12;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            boolean disabled;
            boolean bl = disabled = this.minecraft.gameMode.getPlayerMode() == this.gameMode;
            if (this.selected && !disabled) {
                graphics.fill(this.x, this.y, this.x + this.width, this.y + 12, -12237499);
            }
            if (!disabled && this.selected && this.containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create((Component[])new Component[]{Component.translatable((String)"text.rei.gamemode_button.tooltip.entry", (Object[])new Object[]{this.text})}));
            }
            Object s = this.text;
            if (disabled) {
                s = String.valueOf(ChatFormatting.STRIKETHROUGH) + (String)s;
            }
            graphics.drawString(this.font, (String)s, this.x + 2, this.y + 2, this.selected && !disabled ? 0xFFFFFF : 0x888888, false);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            Minecraft.getInstance().player.connection.sendCommand(StringUtils.removeStart((String)ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", this.gameMode.name().toLowerCase(Locale.ROOT)), (String)"/"));
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.closeMenu();
            return true;
        }

        public boolean containsMouse(double mouseX, double mouseY) {
            boolean disabled = this.minecraft.gameMode.getPlayerMode() == this.gameMode;
            return this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12) && !disabled;
        }
    }

    public static enum Type implements FavoriteEntryType<GameModeFavoriteEntry>
    {
        INSTANCE;


        public DataResult<GameModeFavoriteEntry> read(CompoundTag object) {
            String stringValue = object.getStringOr(GameModeFavoriteEntry.KEY, "NOT_SET");
            GameType type = stringValue.equals("NOT_SET") ? null : GameType.valueOf((String)stringValue);
            return DataResult.success((Object)((Object)new GameModeFavoriteEntry(type)), (Lifecycle)Lifecycle.stable());
        }

        public DataResult<GameModeFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create GameModeFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof GameType)) {
                return DataResult.error(() -> "Creation of GameModeFavoriteEntry from args expected GameType as the first argument!");
            }
            GameType type = (GameType)object;
            return DataResult.success((Object)((Object)new GameModeFavoriteEntry(type)), (Lifecycle)Lifecycle.stable());
        }

        public CompoundTag save(GameModeFavoriteEntry entry, CompoundTag tag) {
            tag.putString(GameModeFavoriteEntry.KEY, entry.gameMode == null ? "NOT_SET" : entry.gameMode.name());
            return tag;
        }
    }
}

