/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.plugin.client.displays.ClientsidedCraftingDisplay;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapedDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapelessDisplay;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultCraftingDisplay
extends BasicDisplay
implements CraftingDisplay {
    public DefaultCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location) {
        super(inputs, outputs, location);
    }

    @Nullable
    public static CraftingDisplay of(RecipeHolder<? extends Recipe<?>> holder) {
        Recipe recipe = holder.value();
        if (recipe instanceof ShapelessRecipe) {
            return new DefaultShapelessDisplay(holder);
        }
        if (recipe instanceof ShapedRecipe) {
            return new DefaultShapedDisplay(holder);
        }
        if (!recipe.isSpecial()) {
            for (RecipeDisplay d : recipe.display()) {
                if (d instanceof ShapedCraftingRecipeDisplay) {
                    ShapedCraftingRecipeDisplay display = (ShapedCraftingRecipeDisplay)d;
                    return new ClientsidedCraftingDisplay.Shaped(display, Optional.empty());
                }
                if (!(d instanceof ShapelessCraftingRecipeDisplay)) continue;
                ShapelessCraftingRecipeDisplay display = (ShapelessCraftingRecipeDisplay)d;
                return new ClientsidedCraftingDisplay.Shapeless(display, Optional.empty());
            }
        }
        return null;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }
}

