/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.anvil;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.anvil.AnvilRecipe;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class DefaultAnvilDisplay
extends BasicDisplay {
    public static final DisplaySerializer<DefaultAnvilDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Identifier.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation), (App)Codec.INT.optionalFieldOf("cost").forGetter(d -> d.cost.stream().boxed().findFirst())).apply((Applicative)instance, (inputs, outputs, location, cost) -> new DefaultAnvilDisplay((List<EntryIngredient>)inputs, (List<EntryIngredient>)outputs, (Optional<Identifier>)location, cost.stream().mapToInt(i -> i).findFirst()))), (StreamCodec)StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Identifier.STREAM_CODEC), BasicDisplay::getDisplayLocation, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), d -> d.cost.stream().boxed().findFirst(), (inputs, outputs, location, cost) -> new DefaultAnvilDisplay((List<EntryIngredient>)inputs, (List<EntryIngredient>)outputs, (Optional<Identifier>)location, cost.stream().mapToInt(i -> i).findFirst())));
    private final OptionalInt cost;

    public DefaultAnvilDisplay(AnvilRecipe recipe) {
        this(Arrays.asList(EntryIngredients.ofItemStacks(recipe.getLeftInput()), EntryIngredients.ofItemStacks(recipe.getRightInputs())), Collections.singletonList(EntryIngredients.ofItemStacks(recipe.getOutputs())), Optional.ofNullable(recipe.getId()), recipe.getCost());
    }

    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<Identifier> location) {
        this(inputs, outputs, location, OptionalInt.empty());
    }

    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<Identifier> location, CompoundTag tag) {
        this(inputs, outputs, location, tag.contains("Cost") ? (OptionalInt)Util.make(() -> tag.getInt("Cost").isPresent() ? OptionalInt.of((Integer)tag.getInt("Cost").get()) : OptionalInt.empty()) : OptionalInt.empty());
    }

    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<Identifier> location, OptionalInt cost) {
        super(inputs, outputs, location);
        this.cost = cost;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.ANVIL;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public OptionalInt getCost() {
        return this.cost;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Environment(value=EnvType.CLIENT)
    public static Optional<Pair<ItemStack, Integer>> calculateOutput(ItemStack left, ItemStack right) {
        try {
            if (Minecraft.getInstance().player == null) {
                return Optional.empty();
            }
            AnvilMenu menu = new AnvilMenu(0, new Inventory((Player)Minecraft.getInstance().player, new EntityEquipment()));
            menu.setItem(0, menu.incrementStateId(), left);
            menu.setItem(1, menu.incrementStateId(), right);
            ItemStack output = menu.getSlot(2).getItem().copy();
            if (!output.isEmpty()) {
                return Optional.of(Pair.of((Object)output, (Object)menu.getCost()));
            }
            return Optional.empty();
        }
        catch (Throwable ignored) {
            return Optional.empty();
        }
    }
}

