/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.SmithingDisplay;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DefaultSmithingDisplay
extends BasicDisplay
implements SmithingDisplay {
    public static final DisplaySerializer<DefaultSmithingDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)SmithingDisplay.SmithingRecipeType.CODEC.optionalFieldOf("type").forGetter(d -> d.type), (App)Identifier.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation)).apply((Applicative)instance, DefaultSmithingDisplay::new)), (StreamCodec)StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional(SmithingDisplay.SmithingRecipeType.STREAM_CODEC), d -> d.type, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Identifier.STREAM_CODEC), BasicDisplay::getDisplayLocation, DefaultSmithingDisplay::new));
    protected final Optional<SmithingDisplay.SmithingRecipeType> type;

    @ApiStatus.Experimental
    public static DefaultSmithingDisplay ofTransforming(RecipeHolder<SmithingTransformRecipe> recipe) {
        return new DefaultSmithingDisplay(List.of(((SmithingTransformRecipe)recipe.value()).templateIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()), EntryIngredients.ofIngredient((Ingredient)((SmithingTransformRecipe)recipe.value()).baseIngredient()), ((SmithingTransformRecipe)recipe.value()).additionIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty())), List.of(EntryIngredients.ofSlotDisplay((SlotDisplay)((SmithingTransformRecipe)recipe.value()).result.display())), Optional.of(SmithingDisplay.SmithingRecipeType.TRANSFORM), Optional.of(recipe.id().identifier()));
    }

    public static List<DefaultSmithingDisplay> fromTrimming(RecipeHolder<SmithingTrimRecipe> recipe) {
        RegistryAccess registryAccess = BasicDisplay.registryAccess();
        ArrayList<DefaultSmithingDisplay> displays = new ArrayList<DefaultSmithingDisplay>();
        Holder trimPattern = ((SmithingTrimRecipe)recipe.value()).pattern;
        for (Holder additionStack : ((SmithingTrimRecipe)recipe.value()).additionIngredient().map(Ingredient::items).orElse(Stream.of(new Holder[0]))::iterator) {
            Holder trimMaterial = DefaultSmithingDisplay.getMaterialFromIngredient((HolderLookup.Provider)registryAccess, (Holder<Item>)additionStack).orElse(null);
            if (trimMaterial == null) continue;
            EntryIngredient baseIngredient = EntryIngredients.ofIngredient((Ingredient)((SmithingTrimRecipe)recipe.value()).baseIngredient());
            displays.add(new Trimming(List.of(((SmithingTrimRecipe)recipe.value()).templateIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()), baseIngredient, EntryIngredients.ofItemHolder((Holder)additionStack)), List.of(baseIngredient), Optional.of(SmithingDisplay.SmithingRecipeType.TRIM), Optional.of(recipe.id().identifier()), (Holder<TrimPattern>)((SmithingTrimRecipe)recipe.value()).pattern));
        }
        return displays;
    }

    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<Identifier> location) {
        this(inputs, outputs, Optional.empty(), location);
    }

    @ApiStatus.Experimental
    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<SmithingDisplay.SmithingRecipeType> type, Optional<Identifier> location) {
        super(inputs, outputs, location);
        this.type = type;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.SMITHING;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    @Override
    @Nullable
    public SmithingDisplay.SmithingRecipeType type() {
        return this.type.orElse(null);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static EntryIngredient getTrimmingOutput(RegistryAccess registryAccess, Holder<TrimPattern> trimPattern, EntryStack<?> base, EntryStack<?> addition) {
        if (base.getType() != VanillaEntryTypes.ITEM || addition.getType() != VanillaEntryTypes.ITEM) {
            return EntryIngredient.empty();
        }
        ItemStack baseItem = (ItemStack)base.castValue();
        ItemStack additionItem = (ItemStack)addition.castValue();
        if (trimPattern == null) {
            return EntryIngredient.empty();
        }
        Holder trimMaterial = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)additionItem).orElse(null);
        if (trimMaterial == null) {
            return EntryIngredient.empty();
        }
        ArmorTrim armorTrim = new ArmorTrim(trimMaterial, trimPattern);
        ArmorTrim trim = (ArmorTrim)baseItem.get(DataComponents.TRIM);
        if (Objects.equals(trim, armorTrim)) {
            return EntryIngredient.empty();
        }
        ItemStack newItem = baseItem.copyWithCount(1);
        newItem.set(DataComponents.TRIM, (Object)armorTrim);
        return EntryIngredients.of((ItemStack)newItem);
    }

    private static Optional<Holder<TrimMaterial>> getMaterialFromIngredient(HolderLookup.Provider provider, Holder<Item> item) {
        ProvidesTrimMaterial providesTrimMaterial = (ProvidesTrimMaterial)new ItemStack(item).get(DataComponents.PROVIDES_TRIM_MATERIAL);
        return providesTrimMaterial != null ? providesTrimMaterial.unwrap(provider) : Optional.empty();
    }

    public static class Trimming
    extends DefaultSmithingDisplay
    implements SmithingDisplay.Trimming {
        public static final DisplaySerializer<Trimming> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)SmithingDisplay.SmithingRecipeType.CODEC.optionalFieldOf("smithing_type").forGetter(d -> d.type), (App)Identifier.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation), (App)TrimPattern.CODEC.fieldOf("pattern").forGetter(Trimming::pattern)).apply((Applicative)instance, Trimming::new)), (StreamCodec)StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional(SmithingDisplay.SmithingRecipeType.STREAM_CODEC), d -> d.type, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Identifier.STREAM_CODEC), BasicDisplay::getDisplayLocation, (StreamCodec)TrimPattern.STREAM_CODEC, Trimming::pattern, Trimming::new));
        private final Holder<TrimPattern> pattern;

        public Trimming(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<SmithingDisplay.SmithingRecipeType> type, Optional<Identifier> location, Holder<TrimPattern> pattern) {
            super(inputs, outputs, type, location);
            this.pattern = pattern;
        }

        @Override
        public Holder<TrimPattern> pattern() {
            return this.pattern;
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }
}

